// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53recoverycontrolconfig

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.*
import aws.sdk.kotlin.services.route53recoverycontrolconfig.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "Route53 Recovery Control Config"
public const val ServiceApiVersion: String = "2020-11-02"
public const val SdkVersion: String = "0.17.8-beta"

internal class DefaultRoute53RecoveryControlConfigClient(override val config: Route53RecoveryControlConfigClient.Config) : Route53RecoveryControlConfigClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Create a new cluster. A cluster is a set of redundant Regional endpoints against which you can run API calls to update or get the state of one or more routing controls. Each cluster has a name, status, Amazon Resource Name (ARN), and an array of the five cluster endpoints (one for each supported Amazon Web Services Region) that you can use with API calls to the cluster data plane.
     */
    override suspend fun createCluster(input: CreateClusterRequest): CreateClusterResponse {
        val op = SdkHttpOperation.build<CreateClusterRequest, CreateClusterResponse> {
            serializer = CreateClusterOperationSerializer()
            deserializer = CreateClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCluster"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-control-config"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new control panel. A control panel represents a group of routing controls that can be changed together in a single transaction. You can use a control panel to centrally view the operational status of applications across your organization, and trigger multi-app failovers in a single transaction, for example, to fail over an Availability Zone or Amazon Web Services Region.
     */
    override suspend fun createControlPanel(input: CreateControlPanelRequest): CreateControlPanelResponse {
        val op = SdkHttpOperation.build<CreateControlPanelRequest, CreateControlPanelResponse> {
            serializer = CreateControlPanelOperationSerializer()
            deserializer = CreateControlPanelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateControlPanel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-control-config"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new routing control.
     *
     * A routing control has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control traffic routing.
     *
     * To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53 Application Recovery Controller.
     */
    override suspend fun createRoutingControl(input: CreateRoutingControlRequest): CreateRoutingControlResponse {
        val op = SdkHttpOperation.build<CreateRoutingControlRequest, CreateRoutingControlResponse> {
            serializer = CreateRoutingControlOperationSerializer()
            deserializer = CreateRoutingControlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateRoutingControl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-control-config"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a safety rule in a control panel. Safety rules let you add safeguards around changing routing control states, and for enabling and disabling routing controls, to help prevent unexpected outcomes.
     *
     * There are two types of safety rules: assertion rules and gating rules.
     *
     * Assertion rule: An assertion rule enforces that, when you change a routing control state, that a certain criteria is met. For example, the criteria might be that at least one routing control state is On after the transation so that traffic continues to flow to at least one cell for the application. This ensures that you avoid a fail-open scenario.
     *
     * Gating rule: A gating rule lets you configure a gating routing control as an overall "on/off" switch for a group of routing controls. Or, you can configure more complex gating scenarios, for example by configuring multiple gating routing controls.
     *
     * For more information, see [Safety rules](https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.safety-rules.html) in the Amazon Route 53 Application Recovery Controller Developer Guide.
     */
    override suspend fun createSafetyRule(input: CreateSafetyRuleRequest): CreateSafetyRuleResponse {
        val op = SdkHttpOperation.build<CreateSafetyRuleRequest, CreateSafetyRuleResponse> {
            serializer = CreateSafetyRuleOperationSerializer()
            deserializer = CreateSafetyRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSafetyRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-control-config"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete a cluster.
     */
    override suspend fun deleteCluster(input: DeleteClusterRequest): DeleteClusterResponse {
        val op = SdkHttpOperation.build<DeleteClusterRequest, DeleteClusterResponse> {
            serializer = DeleteClusterOperationSerializer()
            deserializer = DeleteClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCluster"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-control-config"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a control panel.
     */
    override suspend fun deleteControlPanel(input: DeleteControlPanelRequest): DeleteControlPanelResponse {
        val op = SdkHttpOperation.build<DeleteControlPanelRequest, DeleteControlPanelResponse> {
            serializer = DeleteControlPanelOperationSerializer()
            deserializer = DeleteControlPanelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteControlPanel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-control-config"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a routing control.
     */
    override suspend fun deleteRoutingControl(input: DeleteRoutingControlRequest): DeleteRoutingControlResponse {
        val op = SdkHttpOperation.build<DeleteRoutingControlRequest, DeleteRoutingControlResponse> {
            serializer = DeleteRoutingControlOperationSerializer()
            deserializer = DeleteRoutingControlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteRoutingControl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-control-config"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a safety rule.
     *
     * />
     */
    override suspend fun deleteSafetyRule(input: DeleteSafetyRuleRequest): DeleteSafetyRuleResponse {
        val op = SdkHttpOperation.build<DeleteSafetyRuleRequest, DeleteSafetyRuleResponse> {
            serializer = DeleteSafetyRuleOperationSerializer()
            deserializer = DeleteSafetyRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSafetyRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-control-config"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Display the details about a cluster. The response includes the cluster name, endpoints, status, and Amazon Resource Name (ARN).
     */
    override suspend fun describeCluster(input: DescribeClusterRequest): DescribeClusterResponse {
        val op = SdkHttpOperation.build<DescribeClusterRequest, DescribeClusterResponse> {
            serializer = DescribeClusterOperationSerializer()
            deserializer = DescribeClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCluster"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-control-config"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Displays details about a control panel.
     */
    override suspend fun describeControlPanel(input: DescribeControlPanelRequest): DescribeControlPanelResponse {
        val op = SdkHttpOperation.build<DescribeControlPanelRequest, DescribeControlPanelResponse> {
            serializer = DescribeControlPanelOperationSerializer()
            deserializer = DescribeControlPanelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeControlPanel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-control-config"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Displays details about a routing control. A routing control has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control routing.
     *
     * To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53 Application Recovery Controller.
     */
    override suspend fun describeRoutingControl(input: DescribeRoutingControlRequest): DescribeRoutingControlResponse {
        val op = SdkHttpOperation.build<DescribeRoutingControlRequest, DescribeRoutingControlResponse> {
            serializer = DescribeRoutingControlOperationSerializer()
            deserializer = DescribeRoutingControlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRoutingControl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-control-config"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a safety rule.
     */
    override suspend fun describeSafetyRule(input: DescribeSafetyRuleRequest): DescribeSafetyRuleResponse {
        val op = SdkHttpOperation.build<DescribeSafetyRuleRequest, DescribeSafetyRuleResponse> {
            serializer = DescribeSafetyRuleOperationSerializer()
            deserializer = DescribeSafetyRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSafetyRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-control-config"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of all Amazon Route 53 health checks associated with a specific routing control.
     */
    override suspend fun listAssociatedRoute53HealthChecks(input: ListAssociatedRoute53HealthChecksRequest): ListAssociatedRoute53HealthChecksResponse {
        val op = SdkHttpOperation.build<ListAssociatedRoute53HealthChecksRequest, ListAssociatedRoute53HealthChecksResponse> {
            serializer = ListAssociatedRoute53HealthChecksOperationSerializer()
            deserializer = ListAssociatedRoute53HealthChecksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAssociatedRoute53HealthChecks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-control-config"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of all the clusters in an account.
     */
    override suspend fun listClusters(input: ListClustersRequest): ListClustersResponse {
        val op = SdkHttpOperation.build<ListClustersRequest, ListClustersResponse> {
            serializer = ListClustersOperationSerializer()
            deserializer = ListClustersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListClusters"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-control-config"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of control panels in an account or in a cluster.
     */
    override suspend fun listControlPanels(input: ListControlPanelsRequest): ListControlPanelsResponse {
        val op = SdkHttpOperation.build<ListControlPanelsRequest, ListControlPanelsResponse> {
            serializer = ListControlPanelsOperationSerializer()
            deserializer = ListControlPanelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListControlPanels"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-control-config"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of routing controls for a control panel. A routing control is an Amazon Route 53 Application Recovery Controller construct that has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control routing.
     */
    override suspend fun listRoutingControls(input: ListRoutingControlsRequest): ListRoutingControlsResponse {
        val op = SdkHttpOperation.build<ListRoutingControlsRequest, ListRoutingControlsResponse> {
            serializer = ListRoutingControlsOperationSerializer()
            deserializer = ListRoutingControlsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRoutingControls"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-control-config"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the safety rules (the assertion rules and gating rules) that you've defined for the routing controls in a control panel.
     */
    override suspend fun listSafetyRules(input: ListSafetyRulesRequest): ListSafetyRulesResponse {
        val op = SdkHttpOperation.build<ListSafetyRulesRequest, ListSafetyRulesResponse> {
            serializer = ListSafetyRulesOperationSerializer()
            deserializer = ListSafetyRulesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSafetyRules"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-control-config"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags for a resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-control-config"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a tag to a resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-control-config"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a tag from a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-control-config"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a control panel. The only update you can make to a control panel is to change the name of the control panel.
     */
    override suspend fun updateControlPanel(input: UpdateControlPanelRequest): UpdateControlPanelResponse {
        val op = SdkHttpOperation.build<UpdateControlPanelRequest, UpdateControlPanelResponse> {
            serializer = UpdateControlPanelOperationSerializer()
            deserializer = UpdateControlPanelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateControlPanel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-control-config"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a routing control. You can only update the name of the routing control. To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53 Application Recovery Controller.
     */
    override suspend fun updateRoutingControl(input: UpdateRoutingControlRequest): UpdateRoutingControlResponse {
        val op = SdkHttpOperation.build<UpdateRoutingControlRequest, UpdateRoutingControlResponse> {
            serializer = UpdateRoutingControlOperationSerializer()
            deserializer = UpdateRoutingControlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRoutingControl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-control-config"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update a safety rule (an assertion rule or gating rule). You can only update the name and the waiting period for a safety rule. To make other updates, delete the safety rule and create a new one.
     */
    override suspend fun updateSafetyRule(input: UpdateSafetyRuleRequest): UpdateSafetyRuleResponse {
        val op = SdkHttpOperation.build<UpdateSafetyRuleRequest, UpdateSafetyRuleResponse> {
            serializer = UpdateSafetyRuleOperationSerializer()
            deserializer = UpdateSafetyRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSafetyRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53-recovery-control-config"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "route53-recovery-control-config")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
