// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53recoverycontrolconfig

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.route53recoverycontrolconfig.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.*
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.CreateClusterRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.CreateClusterResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.CreateControlPanelRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.CreateControlPanelResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.CreateRoutingControlRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.CreateRoutingControlResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.CreateSafetyRuleRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.CreateSafetyRuleResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DeleteClusterRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DeleteClusterResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DeleteControlPanelRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DeleteControlPanelResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DeleteRoutingControlRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DeleteRoutingControlResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DeleteSafetyRuleRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DeleteSafetyRuleResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DescribeClusterRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DescribeClusterResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DescribeControlPanelRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DescribeControlPanelResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DescribeRoutingControlRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DescribeRoutingControlResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DescribeSafetyRuleRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.DescribeSafetyRuleResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListClustersRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListClustersResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListControlPanelsRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListControlPanelsResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListRoutingControlsRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListRoutingControlsResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListSafetyRulesRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListSafetyRulesResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.TagResourceRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.TagResourceResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.UntagResourceRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.UntagResourceResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.UpdateControlPanelRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.UpdateControlPanelResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.UpdateRoutingControlRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.UpdateRoutingControlResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.UpdateSafetyRuleRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Recovery Control Configuration API Reference for Amazon Route 53 Application Recovery Controller
 */
public interface Route53RecoveryControlConfigClient : SdkClient {

    override val serviceName: String
        get() = "Route53 Recovery Control Config"
    /**
     * Route53RecoveryControlConfigClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): Route53RecoveryControlConfigClient {
            val config = Config.Builder().apply(block).build()
            return DefaultRoute53RecoveryControlConfigClient(config)
        }

        public operator fun invoke(config: Config): Route53RecoveryControlConfigClient = DefaultRoute53RecoveryControlConfigClient(config)

        /**
         * Construct a [Route53RecoveryControlConfigClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): Route53RecoveryControlConfigClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultRoute53RecoveryControlConfigClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Create a new cluster. A cluster is a set of redundant Regional endpoints against which you can run API calls to update or get the state of one or more routing controls. Each cluster has a name, status, Amazon Resource Name (ARN), and an array of the five cluster endpoints (one for each supported Amazon Web Services Region) that you can use with API calls to the cluster data plane.
     */
    public suspend fun createCluster(input: CreateClusterRequest): CreateClusterResponse

    /**
     * Creates a new control panel. A control panel represents a group of routing controls that can be changed together in a single transaction. You can use a control panel to centrally view the operational status of applications across your organization, and trigger multi-app failovers in a single transaction, for example, to fail over an Availability Zone or Amazon Web Services Region.
     */
    public suspend fun createControlPanel(input: CreateControlPanelRequest): CreateControlPanelResponse

    /**
     * Creates a new routing control.
     *
     * A routing control has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control traffic routing.
     *
     * To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53 Application Recovery Controller.
     */
    public suspend fun createRoutingControl(input: CreateRoutingControlRequest): CreateRoutingControlResponse

    /**
     * Creates a safety rule in a control panel. Safety rules let you add safeguards around changing routing control states, and for enabling and disabling routing controls, to help prevent unexpected outcomes.
     *
     * There are two types of safety rules: assertion rules and gating rules.
     *
     * Assertion rule: An assertion rule enforces that, when you change a routing control state, that a certain criteria is met. For example, the criteria might be that at least one routing control state is On after the transation so that traffic continues to flow to at least one cell for the application. This ensures that you avoid a fail-open scenario.
     *
     * Gating rule: A gating rule lets you configure a gating routing control as an overall "on/off" switch for a group of routing controls. Or, you can configure more complex gating scenarios, for example by configuring multiple gating routing controls.
     *
     * For more information, see [Safety rules](https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.safety-rules.html) in the Amazon Route 53 Application Recovery Controller Developer Guide.
     */
    public suspend fun createSafetyRule(input: CreateSafetyRuleRequest = CreateSafetyRuleRequest {}): CreateSafetyRuleResponse

    /**
     * Delete a cluster.
     */
    public suspend fun deleteCluster(input: DeleteClusterRequest): DeleteClusterResponse

    /**
     * Deletes a control panel.
     */
    public suspend fun deleteControlPanel(input: DeleteControlPanelRequest): DeleteControlPanelResponse

    /**
     * Deletes a routing control.
     */
    public suspend fun deleteRoutingControl(input: DeleteRoutingControlRequest): DeleteRoutingControlResponse

    /**
     * Deletes a safety rule.
     *
     * />
     */
    public suspend fun deleteSafetyRule(input: DeleteSafetyRuleRequest): DeleteSafetyRuleResponse

    /**
     * Display the details about a cluster. The response includes the cluster name, endpoints, status, and Amazon Resource Name (ARN).
     */
    public suspend fun describeCluster(input: DescribeClusterRequest): DescribeClusterResponse

    /**
     * Displays details about a control panel.
     */
    public suspend fun describeControlPanel(input: DescribeControlPanelRequest): DescribeControlPanelResponse

    /**
     * Displays details about a routing control. A routing control has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control routing.
     *
     * To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53 Application Recovery Controller.
     */
    public suspend fun describeRoutingControl(input: DescribeRoutingControlRequest): DescribeRoutingControlResponse

    /**
     * Returns information about a safety rule.
     */
    public suspend fun describeSafetyRule(input: DescribeSafetyRuleRequest): DescribeSafetyRuleResponse

    /**
     * Returns an array of all Amazon Route 53 health checks associated with a specific routing control.
     */
    public suspend fun listAssociatedRoute53HealthChecks(input: ListAssociatedRoute53HealthChecksRequest): ListAssociatedRoute53HealthChecksResponse

    /**
     * Returns an array of all the clusters in an account.
     */
    public suspend fun listClusters(input: ListClustersRequest = ListClustersRequest {}): ListClustersResponse

    /**
     * Returns an array of control panels in an account or in a cluster.
     */
    public suspend fun listControlPanels(input: ListControlPanelsRequest = ListControlPanelsRequest {}): ListControlPanelsResponse

    /**
     * Returns an array of routing controls for a control panel. A routing control is an Amazon Route 53 Application Recovery Controller construct that has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control routing.
     */
    public suspend fun listRoutingControls(input: ListRoutingControlsRequest): ListRoutingControlsResponse

    /**
     * List the safety rules (the assertion rules and gating rules) that you've defined for the routing controls in a control panel.
     */
    public suspend fun listSafetyRules(input: ListSafetyRulesRequest): ListSafetyRulesResponse

    /**
     * Lists the tags for a resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds a tag to a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a control panel. The only update you can make to a control panel is to change the name of the control panel.
     */
    public suspend fun updateControlPanel(input: UpdateControlPanelRequest): UpdateControlPanelResponse

    /**
     * Updates a routing control. You can only update the name of the routing control. To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53 Application Recovery Controller.
     */
    public suspend fun updateRoutingControl(input: UpdateRoutingControlRequest): UpdateRoutingControlResponse

    /**
     * Update a safety rule (an assertion rule or gating rule). You can only update the name and the waiting period for a safety rule. To make other updates, delete the safety rule and create a new one.
     */
    public suspend fun updateSafetyRule(input: UpdateSafetyRuleRequest = UpdateSafetyRuleRequest {}): UpdateSafetyRuleResponse
}

/**
 * Create a new cluster. A cluster is a set of redundant Regional endpoints against which you can run API calls to update or get the state of one or more routing controls. Each cluster has a name, status, Amazon Resource Name (ARN), and an array of the five cluster endpoints (one for each supported Amazon Web Services Region) that you can use with API calls to the cluster data plane.
 */
public suspend inline fun Route53RecoveryControlConfigClient.createCluster(crossinline block: CreateClusterRequest.Builder.() -> Unit): CreateClusterResponse = createCluster(CreateClusterRequest.Builder().apply(block).build())

/**
 * Creates a new control panel. A control panel represents a group of routing controls that can be changed together in a single transaction. You can use a control panel to centrally view the operational status of applications across your organization, and trigger multi-app failovers in a single transaction, for example, to fail over an Availability Zone or Amazon Web Services Region.
 */
public suspend inline fun Route53RecoveryControlConfigClient.createControlPanel(crossinline block: CreateControlPanelRequest.Builder.() -> Unit): CreateControlPanelResponse = createControlPanel(CreateControlPanelRequest.Builder().apply(block).build())

/**
 * Creates a new routing control.
 *
 * A routing control has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control traffic routing.
 *
 * To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53 Application Recovery Controller.
 */
public suspend inline fun Route53RecoveryControlConfigClient.createRoutingControl(crossinline block: CreateRoutingControlRequest.Builder.() -> Unit): CreateRoutingControlResponse = createRoutingControl(CreateRoutingControlRequest.Builder().apply(block).build())

/**
 * Creates a safety rule in a control panel. Safety rules let you add safeguards around changing routing control states, and for enabling and disabling routing controls, to help prevent unexpected outcomes.
 *
 * There are two types of safety rules: assertion rules and gating rules.
 *
 * Assertion rule: An assertion rule enforces that, when you change a routing control state, that a certain criteria is met. For example, the criteria might be that at least one routing control state is On after the transation so that traffic continues to flow to at least one cell for the application. This ensures that you avoid a fail-open scenario.
 *
 * Gating rule: A gating rule lets you configure a gating routing control as an overall "on/off" switch for a group of routing controls. Or, you can configure more complex gating scenarios, for example by configuring multiple gating routing controls.
 *
 * For more information, see [Safety rules](https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.safety-rules.html) in the Amazon Route 53 Application Recovery Controller Developer Guide.
 */
public suspend inline fun Route53RecoveryControlConfigClient.createSafetyRule(crossinline block: CreateSafetyRuleRequest.Builder.() -> Unit): CreateSafetyRuleResponse = createSafetyRule(CreateSafetyRuleRequest.Builder().apply(block).build())

/**
 * Delete a cluster.
 */
public suspend inline fun Route53RecoveryControlConfigClient.deleteCluster(crossinline block: DeleteClusterRequest.Builder.() -> Unit): DeleteClusterResponse = deleteCluster(DeleteClusterRequest.Builder().apply(block).build())

/**
 * Deletes a control panel.
 */
public suspend inline fun Route53RecoveryControlConfigClient.deleteControlPanel(crossinline block: DeleteControlPanelRequest.Builder.() -> Unit): DeleteControlPanelResponse = deleteControlPanel(DeleteControlPanelRequest.Builder().apply(block).build())

/**
 * Deletes a routing control.
 */
public suspend inline fun Route53RecoveryControlConfigClient.deleteRoutingControl(crossinline block: DeleteRoutingControlRequest.Builder.() -> Unit): DeleteRoutingControlResponse = deleteRoutingControl(DeleteRoutingControlRequest.Builder().apply(block).build())

/**
 * Deletes a safety rule.
 *
 * />
 */
public suspend inline fun Route53RecoveryControlConfigClient.deleteSafetyRule(crossinline block: DeleteSafetyRuleRequest.Builder.() -> Unit): DeleteSafetyRuleResponse = deleteSafetyRule(DeleteSafetyRuleRequest.Builder().apply(block).build())

/**
 * Display the details about a cluster. The response includes the cluster name, endpoints, status, and Amazon Resource Name (ARN).
 */
public suspend inline fun Route53RecoveryControlConfigClient.describeCluster(crossinline block: DescribeClusterRequest.Builder.() -> Unit): DescribeClusterResponse = describeCluster(DescribeClusterRequest.Builder().apply(block).build())

/**
 * Displays details about a control panel.
 */
public suspend inline fun Route53RecoveryControlConfigClient.describeControlPanel(crossinline block: DescribeControlPanelRequest.Builder.() -> Unit): DescribeControlPanelResponse = describeControlPanel(DescribeControlPanelRequest.Builder().apply(block).build())

/**
 * Displays details about a routing control. A routing control has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control routing.
 *
 * To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53 Application Recovery Controller.
 */
public suspend inline fun Route53RecoveryControlConfigClient.describeRoutingControl(crossinline block: DescribeRoutingControlRequest.Builder.() -> Unit): DescribeRoutingControlResponse = describeRoutingControl(DescribeRoutingControlRequest.Builder().apply(block).build())

/**
 * Returns information about a safety rule.
 */
public suspend inline fun Route53RecoveryControlConfigClient.describeSafetyRule(crossinline block: DescribeSafetyRuleRequest.Builder.() -> Unit): DescribeSafetyRuleResponse = describeSafetyRule(DescribeSafetyRuleRequest.Builder().apply(block).build())

/**
 * Returns an array of all Amazon Route 53 health checks associated with a specific routing control.
 */
public suspend inline fun Route53RecoveryControlConfigClient.listAssociatedRoute53HealthChecks(crossinline block: ListAssociatedRoute53HealthChecksRequest.Builder.() -> Unit): ListAssociatedRoute53HealthChecksResponse = listAssociatedRoute53HealthChecks(ListAssociatedRoute53HealthChecksRequest.Builder().apply(block).build())

/**
 * Returns an array of all the clusters in an account.
 */
public suspend inline fun Route53RecoveryControlConfigClient.listClusters(crossinline block: ListClustersRequest.Builder.() -> Unit): ListClustersResponse = listClusters(ListClustersRequest.Builder().apply(block).build())

/**
 * Returns an array of control panels in an account or in a cluster.
 */
public suspend inline fun Route53RecoveryControlConfigClient.listControlPanels(crossinline block: ListControlPanelsRequest.Builder.() -> Unit): ListControlPanelsResponse = listControlPanels(ListControlPanelsRequest.Builder().apply(block).build())

/**
 * Returns an array of routing controls for a control panel. A routing control is an Amazon Route 53 Application Recovery Controller construct that has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control routing.
 */
public suspend inline fun Route53RecoveryControlConfigClient.listRoutingControls(crossinline block: ListRoutingControlsRequest.Builder.() -> Unit): ListRoutingControlsResponse = listRoutingControls(ListRoutingControlsRequest.Builder().apply(block).build())

/**
 * List the safety rules (the assertion rules and gating rules) that you've defined for the routing controls in a control panel.
 */
public suspend inline fun Route53RecoveryControlConfigClient.listSafetyRules(crossinline block: ListSafetyRulesRequest.Builder.() -> Unit): ListSafetyRulesResponse = listSafetyRules(ListSafetyRulesRequest.Builder().apply(block).build())

/**
 * Lists the tags for a resource.
 */
public suspend inline fun Route53RecoveryControlConfigClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds a tag to a resource.
 */
public suspend inline fun Route53RecoveryControlConfigClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag from a resource.
 */
public suspend inline fun Route53RecoveryControlConfigClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a control panel. The only update you can make to a control panel is to change the name of the control panel.
 */
public suspend inline fun Route53RecoveryControlConfigClient.updateControlPanel(crossinline block: UpdateControlPanelRequest.Builder.() -> Unit): UpdateControlPanelResponse = updateControlPanel(UpdateControlPanelRequest.Builder().apply(block).build())

/**
 * Updates a routing control. You can only update the name of the routing control. To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53 Application Recovery Controller.
 */
public suspend inline fun Route53RecoveryControlConfigClient.updateRoutingControl(crossinline block: UpdateRoutingControlRequest.Builder.() -> Unit): UpdateRoutingControlResponse = updateRoutingControl(UpdateRoutingControlRequest.Builder().apply(block).build())

/**
 * Update a safety rule (an assertion rule or gating rule). You can only update the name and the waiting period for a safety rule. To make other updates, delete the safety rule and create a new one.
 */
public suspend inline fun Route53RecoveryControlConfigClient.updateSafetyRule(crossinline block: UpdateSafetyRuleRequest.Builder.() -> Unit): UpdateSafetyRuleResponse = updateSafetyRule(UpdateSafetyRuleRequest.Builder().apply(block).build())
