// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53recoverycontrolconfig.model



/**
 * An assertion rule enforces that, when you change a routing control state, that the criteria that you set in the rule configuration is met. Otherwise, the change to the routing control is not accepted. For example, the criteria might be that at least one routing control state is On after the transation so that traffic continues to flow to at least one cell for the application. This ensures that you avoid a fail-open scenario.
 */
public class AssertionRule private constructor(builder: Builder) {
    /**
     * The routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed. For example, you might include three routing controls, one for each of three Amazon Web Services Regions.
     */
    public val assertedControls: List<String>? = builder.assertedControls
    /**
     * The Amazon Resource Name (ARN) of the control panel.
     */
    public val controlPanelArn: kotlin.String? = builder.controlPanelArn
    /**
     * Name of the assertion rule. You can use any non-white space character in the name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The criteria that you set for specific assertion routing controls (AssertedControls) that designate how many routing control states must be ON as the result of a transaction. For example, if you have three assertion routing controls, you might specify atleast 2 for your rule configuration. This means that at least two assertion routing control states must be ON, so that at least two Amazon Web Services Regions have traffic flowing to them.
     */
    public val ruleConfig: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RuleConfig? = builder.ruleConfig
    /**
     * The Amazon Resource Name (ARN) of the assertion rule.
     */
    public val safetyRuleArn: kotlin.String? = builder.safetyRuleArn
    /**
     * The deployment status of an assertion rule. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.
     */
    public val status: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.Status? = builder.status
    /**
     * An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.
     */
    public val waitPeriodMs: kotlin.Int = builder.waitPeriodMs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53recoverycontrolconfig.model.AssertionRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssertionRule(")
        append("assertedControls=$assertedControls,")
        append("controlPanelArn=$controlPanelArn,")
        append("name=$name,")
        append("ruleConfig=$ruleConfig,")
        append("safetyRuleArn=$safetyRuleArn,")
        append("status=$status,")
        append("waitPeriodMs=$waitPeriodMs)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assertedControls?.hashCode() ?: 0
        result = 31 * result + (controlPanelArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (ruleConfig?.hashCode() ?: 0)
        result = 31 * result + (safetyRuleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (waitPeriodMs)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssertionRule

        if (assertedControls != other.assertedControls) return false
        if (controlPanelArn != other.controlPanelArn) return false
        if (name != other.name) return false
        if (ruleConfig != other.ruleConfig) return false
        if (safetyRuleArn != other.safetyRuleArn) return false
        if (status != other.status) return false
        if (waitPeriodMs != other.waitPeriodMs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53recoverycontrolconfig.model.AssertionRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed. For example, you might include three routing controls, one for each of three Amazon Web Services Regions.
         */
        public var assertedControls: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the control panel.
         */
        public var controlPanelArn: kotlin.String? = null
        /**
         * Name of the assertion rule. You can use any non-white space character in the name.
         */
        public var name: kotlin.String? = null
        /**
         * The criteria that you set for specific assertion routing controls (AssertedControls) that designate how many routing control states must be ON as the result of a transaction. For example, if you have three assertion routing controls, you might specify atleast 2 for your rule configuration. This means that at least two assertion routing control states must be ON, so that at least two Amazon Web Services Regions have traffic flowing to them.
         */
        public var ruleConfig: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RuleConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the assertion rule.
         */
        public var safetyRuleArn: kotlin.String? = null
        /**
         * The deployment status of an assertion rule. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.
         */
        public var status: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.Status? = null
        /**
         * An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.
         */
        public var waitPeriodMs: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.AssertionRule) : this() {
            this.assertedControls = x.assertedControls
            this.controlPanelArn = x.controlPanelArn
            this.name = x.name
            this.ruleConfig = x.ruleConfig
            this.safetyRuleArn = x.safetyRuleArn
            this.status = x.status
            this.waitPeriodMs = x.waitPeriodMs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53recoverycontrolconfig.model.AssertionRule = AssertionRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RuleConfig] inside the given [block]
         */
        public fun ruleConfig(block: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RuleConfig.Builder.() -> kotlin.Unit) {
            this.ruleConfig = aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RuleConfig.invoke(block)
        }
    }
}
