// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53recoverycontrolconfig.model



/**
 * A control panel represents a group of routing controls that can be changed together in a single transaction.
 */
public class ControlPanel private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the cluster that includes the control panel.
     */
    public val clusterArn: kotlin.String? = builder.clusterArn
    /**
     * The Amazon Resource Name (ARN) of the control panel.
     */
    public val controlPanelArn: kotlin.String? = builder.controlPanelArn
    /**
     * A flag that Amazon Route 53 Application Recovery Controller sets to true to designate the default control panel for a cluster. When you create a cluster, Amazon Route 53 Application Recovery Controller creates a control panel, and sets this flag for that control panel. If you create a control panel yourself, this flag is set to false.
     */
    public val defaultControlPanel: kotlin.Boolean = builder.defaultControlPanel
    /**
     * The name of the control panel. You can use any non-white space character in the name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The number of routing controls in the control panel.
     */
    public val routingControlCount: kotlin.Int = builder.routingControlCount
    /**
     * The deployment status of control panel. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.
     */
    public val status: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.Status? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ControlPanel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ControlPanel(")
        append("clusterArn=$clusterArn,")
        append("controlPanelArn=$controlPanelArn,")
        append("defaultControlPanel=$defaultControlPanel,")
        append("name=$name,")
        append("routingControlCount=$routingControlCount,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterArn?.hashCode() ?: 0
        result = 31 * result + (controlPanelArn?.hashCode() ?: 0)
        result = 31 * result + (defaultControlPanel.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (routingControlCount)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ControlPanel

        if (clusterArn != other.clusterArn) return false
        if (controlPanelArn != other.controlPanelArn) return false
        if (defaultControlPanel != other.defaultControlPanel) return false
        if (name != other.name) return false
        if (routingControlCount != other.routingControlCount) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ControlPanel = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the cluster that includes the control panel.
         */
        public var clusterArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the control panel.
         */
        public var controlPanelArn: kotlin.String? = null
        /**
         * A flag that Amazon Route 53 Application Recovery Controller sets to true to designate the default control panel for a cluster. When you create a cluster, Amazon Route 53 Application Recovery Controller creates a control panel, and sets this flag for that control panel. If you create a control panel yourself, this flag is set to false.
         */
        public var defaultControlPanel: kotlin.Boolean = false
        /**
         * The name of the control panel. You can use any non-white space character in the name.
         */
        public var name: kotlin.String? = null
        /**
         * The number of routing controls in the control panel.
         */
        public var routingControlCount: kotlin.Int = 0
        /**
         * The deployment status of control panel. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.
         */
        public var status: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.Status? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ControlPanel) : this() {
            this.clusterArn = x.clusterArn
            this.controlPanelArn = x.controlPanelArn
            this.defaultControlPanel = x.defaultControlPanel
            this.name = x.name
            this.routingControlCount = x.routingControlCount
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ControlPanel = ControlPanel(this)
    }
}
