// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53recoverycontrolconfig.model



/**
 * A new assertion rule for a control panel.
 */
public class NewAssertionRule private constructor(builder: Builder) {
    /**
     * The routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed. For example, you might include three routing controls, one for each of three Amazon Web Services Regions.
     */
    public val assertedControls: List<String>? = builder.assertedControls
    /**
     * The Amazon Resource Name (ARN) for the control panel.
     */
    public val controlPanelArn: kotlin.String? = builder.controlPanelArn
    /**
     * The name of the assertion rule. You can use any non-white space character in the name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The criteria that you set for specific assertion controls (routing controls) that designate how many control states must be ON as the result of a transaction. For example, if you have three assertion controls, you might specify ATLEAST 2for your rule configuration. This means that at least two assertion controls must be ON, so that at least two Amazon Web Services Regions have traffic flowing to them.
     */
    public val ruleConfig: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RuleConfig? = builder.ruleConfig
    /**
     * An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.
     */
    public val waitPeriodMs: kotlin.Int = builder.waitPeriodMs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53recoverycontrolconfig.model.NewAssertionRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NewAssertionRule(")
        append("assertedControls=$assertedControls,")
        append("controlPanelArn=$controlPanelArn,")
        append("name=$name,")
        append("ruleConfig=$ruleConfig,")
        append("waitPeriodMs=$waitPeriodMs)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assertedControls?.hashCode() ?: 0
        result = 31 * result + (controlPanelArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (ruleConfig?.hashCode() ?: 0)
        result = 31 * result + (waitPeriodMs)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NewAssertionRule

        if (assertedControls != other.assertedControls) return false
        if (controlPanelArn != other.controlPanelArn) return false
        if (name != other.name) return false
        if (ruleConfig != other.ruleConfig) return false
        if (waitPeriodMs != other.waitPeriodMs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53recoverycontrolconfig.model.NewAssertionRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed. For example, you might include three routing controls, one for each of three Amazon Web Services Regions.
         */
        public var assertedControls: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) for the control panel.
         */
        public var controlPanelArn: kotlin.String? = null
        /**
         * The name of the assertion rule. You can use any non-white space character in the name.
         */
        public var name: kotlin.String? = null
        /**
         * The criteria that you set for specific assertion controls (routing controls) that designate how many control states must be ON as the result of a transaction. For example, if you have three assertion controls, you might specify ATLEAST 2for your rule configuration. This means that at least two assertion controls must be ON, so that at least two Amazon Web Services Regions have traffic flowing to them.
         */
        public var ruleConfig: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RuleConfig? = null
        /**
         * An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.
         */
        public var waitPeriodMs: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.NewAssertionRule) : this() {
            this.assertedControls = x.assertedControls
            this.controlPanelArn = x.controlPanelArn
            this.name = x.name
            this.ruleConfig = x.ruleConfig
            this.waitPeriodMs = x.waitPeriodMs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53recoverycontrolconfig.model.NewAssertionRule = NewAssertionRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RuleConfig] inside the given [block]
         */
        public fun ruleConfig(block: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RuleConfig.Builder.() -> kotlin.Unit) {
            this.ruleConfig = aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RuleConfig.invoke(block)
        }
    }
}
