// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53recoverycontrolconfig.model



/**
 * A new gating rule for a control panel.
 */
public class NewGatingRule private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the control panel.
     */
    public val controlPanelArn: kotlin.String? = builder.controlPanelArn
    /**
     * The gating controls for the new gating rule. That is, routing controls that are evaluated by the rule configuration that you specify.
     */
    public val gatingControls: List<String>? = builder.gatingControls
    /**
     * The name for the new gating rule.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The criteria that you set for specific gating controls (routing controls) that designates how many control states must be ON to allow you to change (set or unset) the target control states.
     */
    public val ruleConfig: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RuleConfig? = builder.ruleConfig
    /**
     * Routing controls that can only be set or unset if the specified RuleConfig evaluates to true for the specified GatingControls. For example, say you have three gating controls, one for each of three Amazon Web Services Regions. Now you specify AtLeast 2 as your RuleConfig. With these settings, you can only change (set or unset) the routing controls that you have specified as TargetControls if that rule evaluates to true.
     *
     * In other words, your ability to change the routing controls that you have specified as TargetControls is gated by the rule that you set for the routing controls in GatingControls.
     */
    public val targetControls: List<String>? = builder.targetControls
    /**
     * An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.
     */
    public val waitPeriodMs: kotlin.Int = builder.waitPeriodMs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53recoverycontrolconfig.model.NewGatingRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NewGatingRule(")
        append("controlPanelArn=$controlPanelArn,")
        append("gatingControls=$gatingControls,")
        append("name=$name,")
        append("ruleConfig=$ruleConfig,")
        append("targetControls=$targetControls,")
        append("waitPeriodMs=$waitPeriodMs)")
    }

    override fun hashCode(): kotlin.Int {
        var result = controlPanelArn?.hashCode() ?: 0
        result = 31 * result + (gatingControls?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (ruleConfig?.hashCode() ?: 0)
        result = 31 * result + (targetControls?.hashCode() ?: 0)
        result = 31 * result + (waitPeriodMs)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NewGatingRule

        if (controlPanelArn != other.controlPanelArn) return false
        if (gatingControls != other.gatingControls) return false
        if (name != other.name) return false
        if (ruleConfig != other.ruleConfig) return false
        if (targetControls != other.targetControls) return false
        if (waitPeriodMs != other.waitPeriodMs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53recoverycontrolconfig.model.NewGatingRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the control panel.
         */
        public var controlPanelArn: kotlin.String? = null
        /**
         * The gating controls for the new gating rule. That is, routing controls that are evaluated by the rule configuration that you specify.
         */
        public var gatingControls: List<String>? = null
        /**
         * The name for the new gating rule.
         */
        public var name: kotlin.String? = null
        /**
         * The criteria that you set for specific gating controls (routing controls) that designates how many control states must be ON to allow you to change (set or unset) the target control states.
         */
        public var ruleConfig: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RuleConfig? = null
        /**
         * Routing controls that can only be set or unset if the specified RuleConfig evaluates to true for the specified GatingControls. For example, say you have three gating controls, one for each of three Amazon Web Services Regions. Now you specify AtLeast 2 as your RuleConfig. With these settings, you can only change (set or unset) the routing controls that you have specified as TargetControls if that rule evaluates to true.
         *
         * In other words, your ability to change the routing controls that you have specified as TargetControls is gated by the rule that you set for the routing controls in GatingControls.
         */
        public var targetControls: List<String>? = null
        /**
         * An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.
         */
        public var waitPeriodMs: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.NewGatingRule) : this() {
            this.controlPanelArn = x.controlPanelArn
            this.gatingControls = x.gatingControls
            this.name = x.name
            this.ruleConfig = x.ruleConfig
            this.targetControls = x.targetControls
            this.waitPeriodMs = x.waitPeriodMs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53recoverycontrolconfig.model.NewGatingRule = NewGatingRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RuleConfig] inside the given [block]
         */
        public fun ruleConfig(block: aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RuleConfig.Builder.() -> kotlin.Unit) {
            this.ruleConfig = aws.sdk.kotlin.services.route53recoverycontrolconfig.model.RuleConfig.invoke(block)
        }
    }
}
