// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53recoverycontrolconfig.paginators

import aws.sdk.kotlin.services.route53recoverycontrolconfig.Route53RecoveryControlConfigClient
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListClustersRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListClustersResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListControlPanelsRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListControlPanelsResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListRoutingControlsRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListRoutingControlsResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListSafetyRulesRequest
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.ListSafetyRulesResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListAssociatedRoute53HealthChecksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAssociatedRoute53HealthChecksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssociatedRoute53HealthChecksResponse]
 */
public fun Route53RecoveryControlConfigClient.listAssociatedRoute53HealthChecksPaginated(initialRequest: ListAssociatedRoute53HealthChecksRequest): Flow<ListAssociatedRoute53HealthChecksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAssociatedRoute53HealthChecksPaginated.listAssociatedRoute53HealthChecks(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAssociatedRoute53HealthChecksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssociatedRoute53HealthChecksResponse]
 */
public fun Route53RecoveryControlConfigClient.listAssociatedRoute53HealthChecksPaginated(block: ListAssociatedRoute53HealthChecksRequest.Builder.() -> Unit): Flow<ListAssociatedRoute53HealthChecksResponse> =
    listAssociatedRoute53HealthChecksPaginated(ListAssociatedRoute53HealthChecksRequest.Builder().apply(block).build())

/**
 * Paginate over [ListClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListClustersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClustersResponse]
 */
public fun Route53RecoveryControlConfigClient.listClustersPaginated(initialRequest: ListClustersRequest): Flow<ListClustersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listClustersPaginated.listClusters(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClustersResponse]
 */
public fun Route53RecoveryControlConfigClient.listClustersPaginated(block: ListClustersRequest.Builder.() -> Unit): Flow<ListClustersResponse> =
    listClustersPaginated(ListClustersRequest.Builder().apply(block).build())

/**
 * Paginate over [ListControlPanelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListControlPanelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListControlPanelsResponse]
 */
public fun Route53RecoveryControlConfigClient.listControlPanelsPaginated(initialRequest: ListControlPanelsRequest): Flow<ListControlPanelsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listControlPanelsPaginated.listControlPanels(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListControlPanelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListControlPanelsResponse]
 */
public fun Route53RecoveryControlConfigClient.listControlPanelsPaginated(block: ListControlPanelsRequest.Builder.() -> Unit): Flow<ListControlPanelsResponse> =
    listControlPanelsPaginated(ListControlPanelsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListRoutingControlsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRoutingControlsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRoutingControlsResponse]
 */
public fun Route53RecoveryControlConfigClient.listRoutingControlsPaginated(initialRequest: ListRoutingControlsRequest): Flow<ListRoutingControlsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRoutingControlsPaginated.listRoutingControls(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRoutingControlsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRoutingControlsResponse]
 */
public fun Route53RecoveryControlConfigClient.listRoutingControlsPaginated(block: ListRoutingControlsRequest.Builder.() -> Unit): Flow<ListRoutingControlsResponse> =
    listRoutingControlsPaginated(ListRoutingControlsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListSafetyRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSafetyRulesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSafetyRulesResponse]
 */
public fun Route53RecoveryControlConfigClient.listSafetyRulesPaginated(initialRequest: ListSafetyRulesRequest): Flow<ListSafetyRulesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSafetyRulesPaginated.listSafetyRules(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListSafetyRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSafetyRulesResponse]
 */
public fun Route53RecoveryControlConfigClient.listSafetyRulesPaginated(block: ListSafetyRulesRequest.Builder.() -> Unit): Flow<ListSafetyRulesResponse> =
    listSafetyRulesPaginated(ListSafetyRulesRequest.Builder().apply(block).build())
