// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53recoverycontrolconfig.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.AssertionRule
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.CreateSafetyRuleResponse
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.GatingRule
import aws.sdk.kotlin.services.route53recoverycontrolconfig.model.Route53RecoveryControlConfigException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateSafetyRuleOperationDeserializer: HttpDeserialize<CreateSafetyRuleResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateSafetyRuleResponse {
        if (!response.status.isSuccess()) {
            throwCreateSafetyRuleError(context, response)
        }
        val builder = CreateSafetyRuleResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateSafetyRuleOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateSafetyRuleError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw Route53RecoveryControlConfigException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> Route53RecoveryControlConfigException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateSafetyRuleOperationBody(builder: CreateSafetyRuleResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASSERTIONRULE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AssertionRule"))
    val GATINGRULE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("GatingRule"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSERTIONRULE_DESCRIPTOR)
        field(GATINGRULE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSERTIONRULE_DESCRIPTOR.index -> builder.assertionRule = deserializeAssertionRuleDocument(deserializer)
                GATINGRULE_DESCRIPTOR.index -> builder.gatingRule = deserializeGatingRuleDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
