// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rum

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.rum.model.*
import aws.sdk.kotlin.services.rum.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.middleware.Retry
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "RUM"
const val ServiceApiVersion: String = "2018-05-10"
const val SdkVersion: String = "0.15.1-beta"

internal class DefaultRumClient(override val config: RumClient.Config) : RumClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates a Amazon CloudWatch RUM app monitor, which collects telemetry data from your application and sends that
     * data to RUM. The data includes performance and reliability information such as page load time, client-side errors,
     * and user behavior.
     * You use this operation only to create a new app monitor. To update an existing app monitor, use <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_UpdateAppMonitor.html">UpdateAppMonitor instead.
     * After you create an app monitor, sign in to the CloudWatch RUM console to get
     * the JavaScript code snippet to add to your web application. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-find-code-snippet.html">How do I find a code snippet
     * that I've already generated?
     */
    override suspend fun createAppMonitor(input: CreateAppMonitorRequest): CreateAppMonitorResponse {
        val op = SdkHttpOperation.build<CreateAppMonitorRequest, CreateAppMonitorResponse> {
            serializer = CreateAppMonitorOperationSerializer()
            deserializer = CreateAppMonitorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAppMonitor"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rum"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing app monitor. This immediately stops the collection of data.
     */
    override suspend fun deleteAppMonitor(input: DeleteAppMonitorRequest): DeleteAppMonitorResponse {
        val op = SdkHttpOperation.build<DeleteAppMonitorRequest, DeleteAppMonitorResponse> {
            serializer = DeleteAppMonitorOperationSerializer()
            deserializer = DeleteAppMonitorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAppMonitor"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rum"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the complete configuration information for one app monitor.
     */
    override suspend fun getAppMonitor(input: GetAppMonitorRequest): GetAppMonitorResponse {
        val op = SdkHttpOperation.build<GetAppMonitorRequest, GetAppMonitorResponse> {
            serializer = GetAppMonitorOperationSerializer()
            deserializer = GetAppMonitorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAppMonitor"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rum"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the raw performance events that RUM has collected from your web application,
     * so that you can do your own processing or analysis of this data.
     */
    override suspend fun getAppMonitorData(input: GetAppMonitorDataRequest): GetAppMonitorDataResponse {
        val op = SdkHttpOperation.build<GetAppMonitorDataRequest, GetAppMonitorDataResponse> {
            serializer = GetAppMonitorDataOperationSerializer()
            deserializer = GetAppMonitorDataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAppMonitorData"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rum"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the Amazon CloudWatch RUM app monitors in the account.
     */
    override suspend fun listAppMonitors(input: ListAppMonitorsRequest): ListAppMonitorsResponse {
        val op = SdkHttpOperation.build<ListAppMonitorsRequest, ListAppMonitorsResponse> {
            serializer = ListAppMonitorsOperationSerializer()
            deserializer = ListAppMonitorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAppMonitors"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rum"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Displays the tags associated with a CloudWatch RUM resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rum"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sends telemetry events about your application performance and user behavior to CloudWatch RUM. The code
     * snippet that RUM generates for you to add to your application includes PutRumEvents operations to
     * send this data to RUM.
     * Each PutRumEvents operation can send a batch of events from one user session.
     */
    override suspend fun putRumEvents(input: PutRumEventsRequest): PutRumEventsResponse {
        val op = SdkHttpOperation.build<PutRumEventsRequest, PutRumEventsResponse> {
            serializer = PutRumEventsOperationSerializer()
            deserializer = PutRumEventsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutRumEvents"
                hostPrefix = "dataplane."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rum"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Assigns one or more tags (key-value pairs) to the specified CloudWatch RUM resource. Currently,
     * the only resources that
     * can be tagged app monitors.
     * Tags can help you organize and categorize your resources. You can also use them to scope user
     * permissions by granting a user
     * permission to access or change only resources with certain tag values.
     * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.
     * You can use the TagResource action with a resource that already has tags.
     * If you specify a new tag key for the resource,
     * this tag is appended to the list of tags associated
     * with the alarm. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces
     * the previous value for that tag.
     * You can associate as many as 50 tags with a resource.
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rum"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags from the specified resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rum"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration of an existing app monitor. When you use this operation, only the parts of the app monitor
     * configuration that you specify in this operation are changed. For any parameters that you omit, the existing
     * values are kept.
     * You can't use this operation to change the tags of an existing app monitor. To change the tags of an existing app monitor, use
     * <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_TagResource.html">TagResource.
     * To create a new app monitor, use <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_CreateAppMonitor.html">CreateAppMonitor.
     * After you update an app monitor, sign in to the CloudWatch RUM console to get
     * the updated JavaScript code snippet to add to your web application. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-find-code-snippet.html">How do I find a code snippet
     * that I've already generated?
     */
    override suspend fun updateAppMonitor(input: UpdateAppMonitorRequest): UpdateAppMonitorResponse {
        val op = SdkHttpOperation.build<UpdateAppMonitorRequest, UpdateAppMonitorResponse> {
            serializer = UpdateAppMonitorOperationSerializer()
            deserializer = UpdateAppMonitorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAppMonitor"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "rum"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "rum")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
