// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rum

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.rum.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.rum.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.crt.CrtAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * With Amazon CloudWatch RUM, you can perform real-user monitoring to collect client-side data about
 * your web application performance from actual user sessions in real time. The data collected includes page load
 * times, client-side errors, and user behavior. When you view this data, you can see it all aggregated together and
 * also see breakdowns by the browsers and devices that your customers use.
 *
 * You can use the collected data to quickly identify and debug client-side performance issues. CloudWatch
 * RUM helps you visualize anomalies in your application performance and find relevant debugging data such as error
 * messages, stack traces, and user sessions. You can also use RUM to
 * understand the range of end-user impact including the number of users, geolocations, and browsers used.
 */
interface RumClient : SdkClient {

    override val serviceName: String
        get() = "RUM"
    /**
     * RumClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): RumClient {
            val config = Config.Builder().apply(block).build()
            return DefaultRumClient(config)
        }

        operator fun invoke(config: Config): RumClient = DefaultRumClient(config)

        /**
         * Construct a [RumClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): RumClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultRumClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: CrtAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a Amazon CloudWatch RUM app monitor, which collects telemetry data from your application and sends that
     * data to RUM. The data includes performance and reliability information such as page load time, client-side errors,
     * and user behavior.
     * You use this operation only to create a new app monitor. To update an existing app monitor, use <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_UpdateAppMonitor.html">UpdateAppMonitor instead.
     * After you create an app monitor, sign in to the CloudWatch RUM console to get
     * the JavaScript code snippet to add to your web application. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-find-code-snippet.html">How do I find a code snippet
     * that I've already generated?
     */
    suspend fun createAppMonitor(input: CreateAppMonitorRequest): CreateAppMonitorResponse

    /**
     * Creates a Amazon CloudWatch RUM app monitor, which collects telemetry data from your application and sends that
     * data to RUM. The data includes performance and reliability information such as page load time, client-side errors,
     * and user behavior.
     * You use this operation only to create a new app monitor. To update an existing app monitor, use <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_UpdateAppMonitor.html">UpdateAppMonitor instead.
     * After you create an app monitor, sign in to the CloudWatch RUM console to get
     * the JavaScript code snippet to add to your web application. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-find-code-snippet.html">How do I find a code snippet
     * that I've already generated?
     */
    suspend fun createAppMonitor(block: CreateAppMonitorRequest.Builder.() -> Unit) = createAppMonitor(CreateAppMonitorRequest.Builder().apply(block).build())

    /**
     * Deletes an existing app monitor. This immediately stops the collection of data.
     */
    suspend fun deleteAppMonitor(input: DeleteAppMonitorRequest): DeleteAppMonitorResponse

    /**
     * Deletes an existing app monitor. This immediately stops the collection of data.
     */
    suspend fun deleteAppMonitor(block: DeleteAppMonitorRequest.Builder.() -> Unit) = deleteAppMonitor(DeleteAppMonitorRequest.Builder().apply(block).build())

    /**
     * Retrieves the complete configuration information for one app monitor.
     */
    suspend fun getAppMonitor(input: GetAppMonitorRequest): GetAppMonitorResponse

    /**
     * Retrieves the complete configuration information for one app monitor.
     */
    suspend fun getAppMonitor(block: GetAppMonitorRequest.Builder.() -> Unit) = getAppMonitor(GetAppMonitorRequest.Builder().apply(block).build())

    /**
     * Retrieves the raw performance events that RUM has collected from your web application,
     * so that you can do your own processing or analysis of this data.
     */
    suspend fun getAppMonitorData(input: GetAppMonitorDataRequest): GetAppMonitorDataResponse

    /**
     * Retrieves the raw performance events that RUM has collected from your web application,
     * so that you can do your own processing or analysis of this data.
     */
    suspend fun getAppMonitorData(block: GetAppMonitorDataRequest.Builder.() -> Unit) = getAppMonitorData(GetAppMonitorDataRequest.Builder().apply(block).build())

    /**
     * Returns a list of the Amazon CloudWatch RUM app monitors in the account.
     */
    suspend fun listAppMonitors(input: ListAppMonitorsRequest): ListAppMonitorsResponse

    /**
     * Returns a list of the Amazon CloudWatch RUM app monitors in the account.
     */
    suspend fun listAppMonitors(block: ListAppMonitorsRequest.Builder.() -> Unit) = listAppMonitors(ListAppMonitorsRequest.Builder().apply(block).build())

    /**
     * Displays the tags associated with a CloudWatch RUM resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Displays the tags associated with a CloudWatch RUM resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Sends telemetry events about your application performance and user behavior to CloudWatch RUM. The code
     * snippet that RUM generates for you to add to your application includes PutRumEvents operations to
     * send this data to RUM.
     * Each PutRumEvents operation can send a batch of events from one user session.
     */
    suspend fun putRumEvents(input: PutRumEventsRequest): PutRumEventsResponse

    /**
     * Sends telemetry events about your application performance and user behavior to CloudWatch RUM. The code
     * snippet that RUM generates for you to add to your application includes PutRumEvents operations to
     * send this data to RUM.
     * Each PutRumEvents operation can send a batch of events from one user session.
     */
    suspend fun putRumEvents(block: PutRumEventsRequest.Builder.() -> Unit) = putRumEvents(PutRumEventsRequest.Builder().apply(block).build())

    /**
     * Assigns one or more tags (key-value pairs) to the specified CloudWatch RUM resource. Currently,
     * the only resources that
     * can be tagged app monitors.
     * Tags can help you organize and categorize your resources. You can also use them to scope user
     * permissions by granting a user
     * permission to access or change only resources with certain tag values.
     * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.
     * You can use the TagResource action with a resource that already has tags.
     * If you specify a new tag key for the resource,
     * this tag is appended to the list of tags associated
     * with the alarm. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces
     * the previous value for that tag.
     * You can associate as many as 50 tags with a resource.
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Assigns one or more tags (key-value pairs) to the specified CloudWatch RUM resource. Currently,
     * the only resources that
     * can be tagged app monitors.
     * Tags can help you organize and categorize your resources. You can also use them to scope user
     * permissions by granting a user
     * permission to access or change only resources with certain tag values.
     * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.
     * You can use the TagResource action with a resource that already has tags.
     * If you specify a new tag key for the resource,
     * this tag is appended to the list of tags associated
     * with the alarm. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces
     * the previous value for that tag.
     * You can associate as many as 50 tags with a resource.
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes one or more tags from the specified resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes one or more tags from the specified resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates the configuration of an existing app monitor. When you use this operation, only the parts of the app monitor
     * configuration that you specify in this operation are changed. For any parameters that you omit, the existing
     * values are kept.
     * You can't use this operation to change the tags of an existing app monitor. To change the tags of an existing app monitor, use
     * <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_TagResource.html">TagResource.
     * To create a new app monitor, use <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_CreateAppMonitor.html">CreateAppMonitor.
     * After you update an app monitor, sign in to the CloudWatch RUM console to get
     * the updated JavaScript code snippet to add to your web application. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-find-code-snippet.html">How do I find a code snippet
     * that I've already generated?
     */
    suspend fun updateAppMonitor(input: UpdateAppMonitorRequest): UpdateAppMonitorResponse

    /**
     * Updates the configuration of an existing app monitor. When you use this operation, only the parts of the app monitor
     * configuration that you specify in this operation are changed. For any parameters that you omit, the existing
     * values are kept.
     * You can't use this operation to change the tags of an existing app monitor. To change the tags of an existing app monitor, use
     * <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_TagResource.html">TagResource.
     * To create a new app monitor, use <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_CreateAppMonitor.html">CreateAppMonitor.
     * After you update an app monitor, sign in to the CloudWatch RUM console to get
     * the updated JavaScript code snippet to add to your web application. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-find-code-snippet.html">How do I find a code snippet
     * that I've already generated?
     */
    suspend fun updateAppMonitor(block: UpdateAppMonitorRequest.Builder.() -> Unit) = updateAppMonitor(UpdateAppMonitorRequest.Builder().apply(block).build())
}
