// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rum.model



/**
 * A RUM app monitor collects telemetry data from your application and sends that
 * data to RUM. The data includes performance and reliability information such as page load time, client-side errors,
 * and user behavior.
 */
class AppMonitor private constructor(builder: Builder) {
    /**
     * A structure that contains much of the configuration data for the app monitor.
     */
    val appMonitorConfiguration: aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration? = builder.appMonitorConfiguration
    /**
     * The date and time that this app monitor was created.
     */
    val created: kotlin.String? = builder.created
    /**
     * A structure that contains information about whether this app monitor stores a copy of
     * the telemetry data that RUM collects using CloudWatch Logs.
     */
    val dataStorage: aws.sdk.kotlin.services.rum.model.DataStorage? = builder.dataStorage
    /**
     * The top-level internet domain name for which your application has administrative authority.
     */
    val domain: kotlin.String? = builder.domain
    /**
     * The unique ID of this app monitor.
     */
    val id: kotlin.String? = builder.id
    /**
     * The date and time of the most recent changes to this app monitor's configuration.
     */
    val lastModified: kotlin.String? = builder.lastModified
    /**
     * The name of the app monitor.
     */
    val name: kotlin.String? = builder.name
    /**
     * The current state of the app monitor.
     */
    val state: aws.sdk.kotlin.services.rum.model.StateEnum? = builder.state
    /**
     * The list of tag keys and values associated with this app monitor.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rum.model.AppMonitor = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AppMonitor(")
        append("appMonitorConfiguration=$appMonitorConfiguration,")
        append("created=$created,")
        append("dataStorage=$dataStorage,")
        append("domain=$domain,")
        append("id=$id,")
        append("lastModified=$lastModified,")
        append("name=$name,")
        append("state=$state,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appMonitorConfiguration?.hashCode() ?: 0
        result = 31 * result + (created?.hashCode() ?: 0)
        result = 31 * result + (dataStorage?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastModified?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AppMonitor

        if (appMonitorConfiguration != other.appMonitorConfiguration) return false
        if (created != other.created) return false
        if (dataStorage != other.dataStorage) return false
        if (domain != other.domain) return false
        if (id != other.id) return false
        if (lastModified != other.lastModified) return false
        if (name != other.name) return false
        if (state != other.state) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rum.model.AppMonitor = Builder(this).apply(block).build()

    class Builder {
        /**
         * A structure that contains much of the configuration data for the app monitor.
         */
        var appMonitorConfiguration: aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration? = null
        /**
         * The date and time that this app monitor was created.
         */
        var created: kotlin.String? = null
        /**
         * A structure that contains information about whether this app monitor stores a copy of
         * the telemetry data that RUM collects using CloudWatch Logs.
         */
        var dataStorage: aws.sdk.kotlin.services.rum.model.DataStorage? = null
        /**
         * The top-level internet domain name for which your application has administrative authority.
         */
        var domain: kotlin.String? = null
        /**
         * The unique ID of this app monitor.
         */
        var id: kotlin.String? = null
        /**
         * The date and time of the most recent changes to this app monitor's configuration.
         */
        var lastModified: kotlin.String? = null
        /**
         * The name of the app monitor.
         */
        var name: kotlin.String? = null
        /**
         * The current state of the app monitor.
         */
        var state: aws.sdk.kotlin.services.rum.model.StateEnum? = null
        /**
         * The list of tag keys and values associated with this app monitor.
         */
        var tags: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rum.model.AppMonitor) : this() {
            this.appMonitorConfiguration = x.appMonitorConfiguration
            this.created = x.created
            this.dataStorage = x.dataStorage
            this.domain = x.domain
            this.id = x.id
            this.lastModified = x.lastModified
            this.name = x.name
            this.state = x.state
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rum.model.AppMonitor = AppMonitor(this)

        /**
         * construct an [aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration] inside the given [block]
         */
        fun appMonitorConfiguration(block: aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration.Builder.() -> kotlin.Unit) {
            this.appMonitorConfiguration = aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rum.model.DataStorage] inside the given [block]
         */
        fun dataStorage(block: aws.sdk.kotlin.services.rum.model.DataStorage.Builder.() -> kotlin.Unit) {
            this.dataStorage = aws.sdk.kotlin.services.rum.model.DataStorage.invoke(block)
        }
    }
}
