// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rum.model



/**
 * This structure contains much of the configuration data for the app monitor.
 */
class AppMonitorConfiguration private constructor(builder: Builder) {
    /**
     * If you set this to true, the RUM web client sets two cookies, a session
     * cookie and a user cookie. The cookies allow the RUM web client to collect data relating to
     * the number of users an application has and the behavior of the application across a
     * sequence of events. Cookies are stored in the top-level domain of the current page.
     */
    val allowCookies: kotlin.Boolean? = builder.allowCookies
    /**
     * If you set this to true, RUM enables X-Ray tracing for
     * the user sessions that RUM samples. RUM adds an X-Ray trace header to allowed
     * HTTP requests. It also records an X-Ray segment for allowed HTTP requests.
     * You can see traces and segments from these user sessions in the X-Ray console
     * and the CloudWatch ServiceLens console. For more information, see <a href="https://docs.aws.amazon.com/xray/latest/devguide/aws-xray.html">What is X-Ray?
     */
    val enableXRay: kotlin.Boolean? = builder.enableXRay
    /**
     * A list of URLs in your website or application to exclude from RUM data collection.
     * You can't include both ExcludedPages and IncludedPages in the same operation.
     */
    val excludedPages: List<String>? = builder.excludedPages
    /**
     * A list of pages in the CloudWatch RUM console that are to be displayed with a "favorite" icon.
     */
    val favoritePages: List<String>? = builder.favoritePages
    /**
     * The ARN of the guest IAM role that is attached to the Amazon Cognito identity pool
     * that is used to authorize the sending of data to RUM.
     */
    val guestRoleArn: kotlin.String? = builder.guestRoleArn
    /**
     * The ID of the Amazon Cognito identity pool
     * that is used to authorize the sending of data to RUM.
     */
    val identityPoolId: kotlin.String? = builder.identityPoolId
    /**
     * If this app monitor is to collect data from only certain pages in your application, this structure lists those pages.
     *
     * You can't include both ExcludedPages and IncludedPages in the same operation.
     */
    val includedPages: List<String>? = builder.includedPages
    /**
     * Specifies the percentage of user sessions to use for RUM data collection. Choosing a higher percentage gives you
     * more data but also incurs more costs.
     * The number you specify is the percentage of user sessions that will be used.
     * If you omit this parameter, the default of 10 is used.
     */
    val sessionSampleRate: kotlin.Double = builder.sessionSampleRate
    /**
     * An array that lists the types of telemetry data that this app monitor is to collect.
     *
     *
     *
     * errors indicates that RUM collects data about unhandled JavaScript errors raised
     * by your application.
     *
     *
     * performance indicates that RUM collects performance data about how your application
     * and its resources are loaded and rendered. This includes Core Web Vitals.
     *
     *
     * http indicates that RUM collects data about HTTP errors thrown by your application.
     */
    val telemetries: List<Telemetry>? = builder.telemetries

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AppMonitorConfiguration(")
        append("allowCookies=$allowCookies,")
        append("enableXRay=$enableXRay,")
        append("excludedPages=$excludedPages,")
        append("favoritePages=$favoritePages,")
        append("guestRoleArn=$guestRoleArn,")
        append("identityPoolId=$identityPoolId,")
        append("includedPages=$includedPages,")
        append("sessionSampleRate=$sessionSampleRate,")
        append("telemetries=$telemetries)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowCookies?.hashCode() ?: 0
        result = 31 * result + (enableXRay?.hashCode() ?: 0)
        result = 31 * result + (excludedPages?.hashCode() ?: 0)
        result = 31 * result + (favoritePages?.hashCode() ?: 0)
        result = 31 * result + (guestRoleArn?.hashCode() ?: 0)
        result = 31 * result + (identityPoolId?.hashCode() ?: 0)
        result = 31 * result + (includedPages?.hashCode() ?: 0)
        result = 31 * result + (sessionSampleRate.hashCode())
        result = 31 * result + (telemetries?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AppMonitorConfiguration

        if (allowCookies != other.allowCookies) return false
        if (enableXRay != other.enableXRay) return false
        if (excludedPages != other.excludedPages) return false
        if (favoritePages != other.favoritePages) return false
        if (guestRoleArn != other.guestRoleArn) return false
        if (identityPoolId != other.identityPoolId) return false
        if (includedPages != other.includedPages) return false
        if (sessionSampleRate != other.sessionSampleRate) return false
        if (telemetries != other.telemetries) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * If you set this to true, the RUM web client sets two cookies, a session
         * cookie and a user cookie. The cookies allow the RUM web client to collect data relating to
         * the number of users an application has and the behavior of the application across a
         * sequence of events. Cookies are stored in the top-level domain of the current page.
         */
        var allowCookies: kotlin.Boolean? = null
        /**
         * If you set this to true, RUM enables X-Ray tracing for
         * the user sessions that RUM samples. RUM adds an X-Ray trace header to allowed
         * HTTP requests. It also records an X-Ray segment for allowed HTTP requests.
         * You can see traces and segments from these user sessions in the X-Ray console
         * and the CloudWatch ServiceLens console. For more information, see <a href="https://docs.aws.amazon.com/xray/latest/devguide/aws-xray.html">What is X-Ray?
         */
        var enableXRay: kotlin.Boolean? = null
        /**
         * A list of URLs in your website or application to exclude from RUM data collection.
         * You can't include both ExcludedPages and IncludedPages in the same operation.
         */
        var excludedPages: List<String>? = null
        /**
         * A list of pages in the CloudWatch RUM console that are to be displayed with a "favorite" icon.
         */
        var favoritePages: List<String>? = null
        /**
         * The ARN of the guest IAM role that is attached to the Amazon Cognito identity pool
         * that is used to authorize the sending of data to RUM.
         */
        var guestRoleArn: kotlin.String? = null
        /**
         * The ID of the Amazon Cognito identity pool
         * that is used to authorize the sending of data to RUM.
         */
        var identityPoolId: kotlin.String? = null
        /**
         * If this app monitor is to collect data from only certain pages in your application, this structure lists those pages.
         *
         * You can't include both ExcludedPages and IncludedPages in the same operation.
         */
        var includedPages: List<String>? = null
        /**
         * Specifies the percentage of user sessions to use for RUM data collection. Choosing a higher percentage gives you
         * more data but also incurs more costs.
         * The number you specify is the percentage of user sessions that will be used.
         * If you omit this parameter, the default of 10 is used.
         */
        var sessionSampleRate: kotlin.Double = 0.0
        /**
         * An array that lists the types of telemetry data that this app monitor is to collect.
         *
         *
         *
         * errors indicates that RUM collects data about unhandled JavaScript errors raised
         * by your application.
         *
         *
         * performance indicates that RUM collects performance data about how your application
         * and its resources are loaded and rendered. This includes Core Web Vitals.
         *
         *
         * http indicates that RUM collects data about HTTP errors thrown by your application.
         */
        var telemetries: List<Telemetry>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration) : this() {
            this.allowCookies = x.allowCookies
            this.enableXRay = x.enableXRay
            this.excludedPages = x.excludedPages
            this.favoritePages = x.favoritePages
            this.guestRoleArn = x.guestRoleArn
            this.identityPoolId = x.identityPoolId
            this.includedPages = x.includedPages
            this.sessionSampleRate = x.sessionSampleRate
            this.telemetries = x.telemetries
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration = AppMonitorConfiguration(this)
    }
}
