// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rum.model



/**
 * A structure that defines a key and values that you can use to filter the results. The
 * only performance events that are returned are those that have values matching the ones that
 * you specify in one of your QueryFilter structures.
 * For example, you could specify Browser as the Name
 * and specify Chrome,Firefox as the Values to return
 * events generated only from those browsers.
 * Specifying Invert as the Name
 * works as a "not equal to" filter. For example, specify Invert as the Name
 * and specify Chrome as the value to return all events except events from
 * user sessions with the Chrome browser.
 */
class QueryFilter private constructor(builder: Builder) {
    /**
     * The name of a key to search for.
     * The filter returns only the events that match the Name
     * and Values that you specify.
     *
     * Valid values for Name are Browser | Device | Country |
     * Page | OS | EventType | Invert
     */
    val name: kotlin.String? = builder.name
    /**
     * The values of the Name that are to be be included in the returned results.
     */
    val values: List<String>? = builder.values

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rum.model.QueryFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryFilter(")
        append("name=$name,")
        append("values=$values)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryFilter

        if (name != other.name) return false
        if (values != other.values) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rum.model.QueryFilter = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of a key to search for.
         * The filter returns only the events that match the Name
         * and Values that you specify.
         *
         * Valid values for Name are Browser | Device | Country |
         * Page | OS | EventType | Invert
         */
        var name: kotlin.String? = null
        /**
         * The values of the Name that are to be be included in the returned results.
         */
        var values: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rum.model.QueryFilter) : this() {
            this.name = x.name
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rum.model.QueryFilter = QueryFilter(this)
    }
}
