// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rum.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A structure that contains the information for one performance event that RUM collects from a user session with your
 * application.
 */
class RumEvent private constructor(builder: Builder) {
    /**
     * A string containing details about the event.
     */
    val details: kotlin.String? = builder.details
    /**
     * A unique ID for this event.
     */
    val id: kotlin.String? = builder.id
    /**
     * Metadata about this event, which contains a JSON serialization of the identity of the user for
     * this session. The user information comes from information such as the HTTP user-agent request header
     * and document interface.
     */
    val metadata: kotlin.String? = builder.metadata
    /**
     * The exact time that this event occurred.
     */
    val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp
    /**
     * The JSON schema that denotes the type of event this is, such as a page load or a new session.
     */
    val type: kotlin.String? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rum.model.RumEvent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RumEvent(")
        append("details=$details,")
        append("id=$id,")
        append("metadata=$metadata,")
        append("timestamp=$timestamp,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = details?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RumEvent

        if (details != other.details) return false
        if (id != other.id) return false
        if (metadata != other.metadata) return false
        if (timestamp != other.timestamp) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rum.model.RumEvent = Builder(this).apply(block).build()

    class Builder {
        /**
         * A string containing details about the event.
         */
        var details: kotlin.String? = null
        /**
         * A unique ID for this event.
         */
        var id: kotlin.String? = null
        /**
         * Metadata about this event, which contains a JSON serialization of the identity of the user for
         * this session. The user information comes from information such as the HTTP user-agent request header
         * and document interface.
         */
        var metadata: kotlin.String? = null
        /**
         * The exact time that this event occurred.
         */
        var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The JSON schema that denotes the type of event this is, such as a page load or a new session.
         */
        var type: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rum.model.RumEvent) : this() {
            this.details = x.details
            this.id = x.id
            this.metadata = x.metadata
            this.timestamp = x.timestamp
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rum.model.RumEvent = RumEvent(this)
    }
}
