// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rum.model

import aws.smithy.kotlin.runtime.ErrorMetadata
import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * The request was throttled because of quota limits.
 */
class ThrottlingException private constructor(builder: Builder) : RumException() {

    override val message: kotlin.String? = builder.message
    /**
     * The ID of the service quota that was exceeded.
     */
    val quotaCode: kotlin.String? = builder.quotaCode
    /**
     * The value of a parameter in the request caused an error.
     */
    val retryAfterSeconds: kotlin.Int? = builder.retryAfterSeconds
    /**
     * The ID of the service that is associated with the error.
     */
    val serviceCode: kotlin.String? = builder.serviceCode

    init {
        sdkErrorMetadata.attributes[ErrorMetadata.Retryable] = true
        sdkErrorMetadata.attributes[ErrorMetadata.ThrottlingError] = true
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rum.model.ThrottlingException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ThrottlingException(")
        append("message=$message,")
        append("quotaCode=$quotaCode,")
        append("retryAfterSeconds=$retryAfterSeconds,")
        append("serviceCode=$serviceCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (quotaCode?.hashCode() ?: 0)
        result = 31 * result + (retryAfterSeconds ?: 0)
        result = 31 * result + (serviceCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ThrottlingException

        if (message != other.message) return false
        if (quotaCode != other.quotaCode) return false
        if (retryAfterSeconds != other.retryAfterSeconds) return false
        if (serviceCode != other.serviceCode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rum.model.ThrottlingException = Builder(this).apply(block).build()

    class Builder {
        var message: kotlin.String? = null
        /**
         * The ID of the service quota that was exceeded.
         */
        var quotaCode: kotlin.String? = null
        /**
         * The value of a parameter in the request caused an error.
         */
        var retryAfterSeconds: kotlin.Int? = null
        /**
         * The ID of the service that is associated with the error.
         */
        var serviceCode: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rum.model.ThrottlingException) : this() {
            this.message = x.message
            this.quotaCode = x.quotaCode
            this.retryAfterSeconds = x.retryAfterSeconds
            this.serviceCode = x.serviceCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rum.model.ThrottlingException = ThrottlingException(this)
    }
}
