// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rum.model



class UpdateAppMonitorRequest private constructor(builder: Builder) {
    /**
     * A structure that contains much of the configuration data for the app monitor. If you are using
     * Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the
     * Amazon Cognito identity pool to use for authorization. If you don't include AppMonitorConfiguration, you must set up your own
     * authorization method. For more information, see
     * <a href="https://docs.aws.amazon.com/monitoring/CloudWatch-RUM-get-started-authorization.html">Authorize your application
     * to send data to Amazon Web Services.
     */
    val appMonitorConfiguration: aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration? = builder.appMonitorConfiguration
    /**
     * Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter specifies whether RUM
     * sends a copy of this telemetry data to Amazon CloudWatch Logs
     * in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur
     * Amazon CloudWatch Logs charges.
     */
    val cwLogEnabled: kotlin.Boolean? = builder.cwLogEnabled
    /**
     * The top-level internet domain name for which your application has administrative authority.
     */
    val domain: kotlin.String? = builder.domain
    /**
     * The name of the app monitor to update.
     */
    val name: kotlin.String? = builder.name

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rum.model.UpdateAppMonitorRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAppMonitorRequest(")
        append("appMonitorConfiguration=$appMonitorConfiguration,")
        append("cwLogEnabled=$cwLogEnabled,")
        append("domain=$domain,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appMonitorConfiguration?.hashCode() ?: 0
        result = 31 * result + (cwLogEnabled?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateAppMonitorRequest

        if (appMonitorConfiguration != other.appMonitorConfiguration) return false
        if (cwLogEnabled != other.cwLogEnabled) return false
        if (domain != other.domain) return false
        if (name != other.name) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rum.model.UpdateAppMonitorRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A structure that contains much of the configuration data for the app monitor. If you are using
         * Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the
         * Amazon Cognito identity pool to use for authorization. If you don't include AppMonitorConfiguration, you must set up your own
         * authorization method. For more information, see
         * <a href="https://docs.aws.amazon.com/monitoring/CloudWatch-RUM-get-started-authorization.html">Authorize your application
         * to send data to Amazon Web Services.
         */
        var appMonitorConfiguration: aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration? = null
        /**
         * Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter specifies whether RUM
         * sends a copy of this telemetry data to Amazon CloudWatch Logs
         * in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur
         * Amazon CloudWatch Logs charges.
         */
        var cwLogEnabled: kotlin.Boolean? = null
        /**
         * The top-level internet domain name for which your application has administrative authority.
         */
        var domain: kotlin.String? = null
        /**
         * The name of the app monitor to update.
         */
        var name: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rum.model.UpdateAppMonitorRequest) : this() {
            this.appMonitorConfiguration = x.appMonitorConfiguration
            this.cwLogEnabled = x.cwLogEnabled
            this.domain = x.domain
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rum.model.UpdateAppMonitorRequest = UpdateAppMonitorRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration] inside the given [block]
         */
        fun appMonitorConfiguration(block: aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration.Builder.() -> kotlin.Unit) {
            this.appMonitorConfiguration = aws.sdk.kotlin.services.rum.model.AppMonitorConfiguration.invoke(block)
        }
    }
}
