// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rum.transform

import aws.sdk.kotlin.services.rum.model.GetAppMonitorDataRequest
import aws.sdk.kotlin.services.rum.model.QueryFilter
import aws.sdk.kotlin.services.rum.model.TimeRange
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetAppMonitorDataOperationSerializer: HttpSerialize<GetAppMonitorDataRequest> {
    override suspend fun serialize(context: ExecutionContext, input: GetAppMonitorDataRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "appmonitor",
                "${input.name}".encodeLabel(),
                "data",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeGetAppMonitorDataOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeGetAppMonitorDataOperationBody(context: ExecutionContext, input: GetAppMonitorDataRequest): ByteArray {
    val serializer = JsonSerializer()
    val FILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Filters"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxResults"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val TIMERANGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TimeRange"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FILTERS_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(TIMERANGE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.filters != null) {
            listField(FILTERS_DESCRIPTOR) {
                for (el0 in input.filters) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeQueryFilterDocument))
                }
            }
        }
        if (input.maxResults != 0) field(MAXRESULTS_DESCRIPTOR, input.maxResults)
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.timeRange?.let { field(TIMERANGE_DESCRIPTOR, it, ::serializeTimeRangeDocument) }
    }
    return serializer.toByteArray()
}
