// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.time.Instant

class GetObjectAttributesResponse private constructor(builder: Builder) {
    /**
     * The checksum or digest of the object.
     */
    val checksum: aws.sdk.kotlin.services.s3.model.Checksum? = builder.checksum
    /**
     * Specifies whether the object retrieved was (`true`) or was not (`false`) a delete marker. If `false`, this response header does not appear in the response.
     */
    val deleteMarker: kotlin.Boolean = builder.deleteMarker
    /**
     * An ETag is an opaque identifier assigned by a web server to a specific version of a resource found at a URL.
     */
    val eTag: kotlin.String? = builder.eTag
    /**
     * The creation date of the object.
     */
    val lastModified: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModified
    /**
     * A collection of parts associated with a multipart upload.
     */
    val objectParts: aws.sdk.kotlin.services.s3.model.GetObjectAttributesParts? = builder.objectParts
    /**
     * The size of the object in bytes.
     */
    val objectSize: kotlin.Long = builder.objectSize
    /**
     * If present, indicates that the requester was successfully charged for the request.
     */
    val requestCharged: aws.sdk.kotlin.services.s3.model.RequestCharged? = builder.requestCharged
    /**
     * Provides the storage class information of the object. Amazon S3 returns this header for all objects except for S3 Standard storage class objects.
     *
     * For more information, see [Storage Classes](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html).
     */
    val storageClass: aws.sdk.kotlin.services.s3.model.StorageClass? = builder.storageClass
    /**
     * The version ID of the object.
     */
    val versionId: kotlin.String? = builder.versionId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.GetObjectAttributesResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetObjectAttributesResponse(")
        append("checksum=$checksum,")
        append("deleteMarker=$deleteMarker,")
        append("eTag=$eTag,")
        append("lastModified=$lastModified,")
        append("objectParts=$objectParts,")
        append("objectSize=$objectSize,")
        append("requestCharged=$requestCharged,")
        append("storageClass=$storageClass,")
        append("versionId=$versionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = checksum?.hashCode() ?: 0
        result = 31 * result + (deleteMarker.hashCode())
        result = 31 * result + (eTag?.hashCode() ?: 0)
        result = 31 * result + (lastModified?.hashCode() ?: 0)
        result = 31 * result + (objectParts?.hashCode() ?: 0)
        result = 31 * result + (objectSize.hashCode())
        result = 31 * result + (requestCharged?.hashCode() ?: 0)
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetObjectAttributesResponse

        if (checksum != other.checksum) return false
        if (deleteMarker != other.deleteMarker) return false
        if (eTag != other.eTag) return false
        if (lastModified != other.lastModified) return false
        if (objectParts != other.objectParts) return false
        if (objectSize != other.objectSize) return false
        if (requestCharged != other.requestCharged) return false
        if (storageClass != other.storageClass) return false
        if (versionId != other.versionId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.GetObjectAttributesResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The checksum or digest of the object.
         */
        var checksum: aws.sdk.kotlin.services.s3.model.Checksum? = null
        /**
         * Specifies whether the object retrieved was (`true`) or was not (`false`) a delete marker. If `false`, this response header does not appear in the response.
         */
        var deleteMarker: kotlin.Boolean = false
        /**
         * An ETag is an opaque identifier assigned by a web server to a specific version of a resource found at a URL.
         */
        var eTag: kotlin.String? = null
        /**
         * The creation date of the object.
         */
        var lastModified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A collection of parts associated with a multipart upload.
         */
        var objectParts: aws.sdk.kotlin.services.s3.model.GetObjectAttributesParts? = null
        /**
         * The size of the object in bytes.
         */
        var objectSize: kotlin.Long = 0L
        /**
         * If present, indicates that the requester was successfully charged for the request.
         */
        var requestCharged: aws.sdk.kotlin.services.s3.model.RequestCharged? = null
        /**
         * Provides the storage class information of the object. Amazon S3 returns this header for all objects except for S3 Standard storage class objects.
         *
         * For more information, see [Storage Classes](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html).
         */
        var storageClass: aws.sdk.kotlin.services.s3.model.StorageClass? = null
        /**
         * The version ID of the object.
         */
        var versionId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.GetObjectAttributesResponse) : this() {
            this.checksum = x.checksum
            this.deleteMarker = x.deleteMarker
            this.eTag = x.eTag
            this.lastModified = x.lastModified
            this.objectParts = x.objectParts
            this.objectSize = x.objectSize
            this.requestCharged = x.requestCharged
            this.storageClass = x.storageClass
            this.versionId = x.versionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.GetObjectAttributesResponse = GetObjectAttributesResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.Checksum] inside the given [block]
         */
        fun checksum(block: aws.sdk.kotlin.services.s3.model.Checksum.Builder.() -> kotlin.Unit) {
            this.checksum = aws.sdk.kotlin.services.s3.model.Checksum.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.GetObjectAttributesParts] inside the given [block]
         */
        fun objectParts(block: aws.sdk.kotlin.services.s3.model.GetObjectAttributesParts.Builder.() -> kotlin.Unit) {
            this.objectParts = aws.sdk.kotlin.services.s3.model.GetObjectAttributesParts.invoke(block)
        }
    }
}
