// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.time.Instant

class GetObjectRequest private constructor(builder: Builder) {
    /**
     * The bucket name containing the object.
     *
     * When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see [Using access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html) in the *Amazon S3 User Guide*.
     *
     * When using an Object Lambda access point the hostname takes the form *AccessPointName*-*AccountId*.s3-object-lambda.*Region*.amazonaws.com.
     *
     * When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form ` <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com`. When using this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
     */
    val bucket: kotlin.String? = requireNotNull(builder.bucket) { "A non-null value must be provided for bucket" }
    /**
     * The account ID of the expected bucket owner. If the bucket is owned by a different account, the request fails with the HTTP status code `403 Forbidden` (access denied).
     */
    val expectedBucketOwner: kotlin.String? = builder.expectedBucketOwner
    /**
     * Return the object only if its entity tag (ETag) is the same as the one specified; otherwise, return a 412 (precondition failed) error.
     */
    val ifMatch: kotlin.String? = builder.ifMatch
    /**
     * Return the object only if it has been modified since the specified time; otherwise, return a 304 (not modified) error.
     */
    val ifModifiedSince: aws.smithy.kotlin.runtime.time.Instant? = builder.ifModifiedSince
    /**
     * Return the object only if its entity tag (ETag) is different from the one specified; otherwise, return a 304 (not modified) error.
     */
    val ifNoneMatch: kotlin.String? = builder.ifNoneMatch
    /**
     * Return the object only if it has not been modified since the specified time; otherwise, return a 412 (precondition failed) error.
     */
    val ifUnmodifiedSince: aws.smithy.kotlin.runtime.time.Instant? = builder.ifUnmodifiedSince
    /**
     * Key of the object to get.
     */
    val key: kotlin.String? = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a 'ranged' GET request for the part specified. Useful for downloading just a part of an object.
     */
    val partNumber: kotlin.Int = builder.partNumber
    /**
     * Downloads the specified range bytes of an object. For more information about the HTTP Range header, see [https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35](https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35).
     *
     * Amazon S3 doesn't support retrieving multiple ranges of data per `GET` request.
     */
    val range: kotlin.String? = builder.range
    /**
     * Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from Requester Pays buckets, see [Downloading Objects in Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html) in the *Amazon S3 User Guide*.
     */
    val requestPayer: aws.sdk.kotlin.services.s3.model.RequestPayer? = builder.requestPayer
    /**
     * Sets the `Cache-Control` header of the response.
     */
    val responseCacheControl: kotlin.String? = builder.responseCacheControl
    /**
     * Sets the `Content-Disposition` header of the response
     */
    val responseContentDisposition: kotlin.String? = builder.responseContentDisposition
    /**
     * Sets the `Content-Encoding` header of the response.
     */
    val responseContentEncoding: kotlin.String? = builder.responseContentEncoding
    /**
     * Sets the `Content-Language` header of the response.
     */
    val responseContentLanguage: kotlin.String? = builder.responseContentLanguage
    /**
     * Sets the `Content-Type` header of the response.
     */
    val responseContentType: kotlin.String? = builder.responseContentType
    /**
     * Sets the `Expires` header of the response.
     */
    val responseExpires: aws.smithy.kotlin.runtime.time.Instant? = builder.responseExpires
    /**
     * Specifies the algorithm to use to when decrypting the object (for example, AES256).
     */
    val sseCustomerAlgorithm: kotlin.String? = builder.sseCustomerAlgorithm
    /**
     * Specifies the customer-provided encryption key for Amazon S3 used to encrypt the data. This value is used to decrypt the object when recovering it and must match the one used when storing the data. The key must be appropriate for use with the algorithm specified in the `x-amz-server-side-encryption-customer-algorithm` header.
     */
    val sseCustomerKey: kotlin.String? = builder.sseCustomerKey
    /**
     * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
     */
    val sseCustomerKeyMd5: kotlin.String? = builder.sseCustomerKeyMd5
    /**
     * VersionId used to reference a specific version of the object.
     */
    val versionId: kotlin.String? = builder.versionId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.GetObjectRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetObjectRequest(")
        append("bucket=$bucket,")
        append("expectedBucketOwner=$expectedBucketOwner,")
        append("ifMatch=$ifMatch,")
        append("ifModifiedSince=$ifModifiedSince,")
        append("ifNoneMatch=$ifNoneMatch,")
        append("ifUnmodifiedSince=$ifUnmodifiedSince,")
        append("key=$key,")
        append("partNumber=$partNumber,")
        append("range=$range,")
        append("requestPayer=$requestPayer,")
        append("responseCacheControl=$responseCacheControl,")
        append("responseContentDisposition=$responseContentDisposition,")
        append("responseContentEncoding=$responseContentEncoding,")
        append("responseContentLanguage=$responseContentLanguage,")
        append("responseContentType=$responseContentType,")
        append("responseExpires=$responseExpires,")
        append("sseCustomerAlgorithm=$sseCustomerAlgorithm,")
        append("sseCustomerKey=*** Sensitive Data Redacted ***,")
        append("sseCustomerKeyMd5=$sseCustomerKeyMd5,")
        append("versionId=$versionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (expectedBucketOwner?.hashCode() ?: 0)
        result = 31 * result + (ifMatch?.hashCode() ?: 0)
        result = 31 * result + (ifModifiedSince?.hashCode() ?: 0)
        result = 31 * result + (ifNoneMatch?.hashCode() ?: 0)
        result = 31 * result + (ifUnmodifiedSince?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (partNumber)
        result = 31 * result + (range?.hashCode() ?: 0)
        result = 31 * result + (requestPayer?.hashCode() ?: 0)
        result = 31 * result + (responseCacheControl?.hashCode() ?: 0)
        result = 31 * result + (responseContentDisposition?.hashCode() ?: 0)
        result = 31 * result + (responseContentEncoding?.hashCode() ?: 0)
        result = 31 * result + (responseContentLanguage?.hashCode() ?: 0)
        result = 31 * result + (responseContentType?.hashCode() ?: 0)
        result = 31 * result + (responseExpires?.hashCode() ?: 0)
        result = 31 * result + (sseCustomerAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (sseCustomerKey?.hashCode() ?: 0)
        result = 31 * result + (sseCustomerKeyMd5?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetObjectRequest

        if (bucket != other.bucket) return false
        if (expectedBucketOwner != other.expectedBucketOwner) return false
        if (ifMatch != other.ifMatch) return false
        if (ifModifiedSince != other.ifModifiedSince) return false
        if (ifNoneMatch != other.ifNoneMatch) return false
        if (ifUnmodifiedSince != other.ifUnmodifiedSince) return false
        if (key != other.key) return false
        if (partNumber != other.partNumber) return false
        if (range != other.range) return false
        if (requestPayer != other.requestPayer) return false
        if (responseCacheControl != other.responseCacheControl) return false
        if (responseContentDisposition != other.responseContentDisposition) return false
        if (responseContentEncoding != other.responseContentEncoding) return false
        if (responseContentLanguage != other.responseContentLanguage) return false
        if (responseContentType != other.responseContentType) return false
        if (responseExpires != other.responseExpires) return false
        if (sseCustomerAlgorithm != other.sseCustomerAlgorithm) return false
        if (sseCustomerKey != other.sseCustomerKey) return false
        if (sseCustomerKeyMd5 != other.sseCustomerKeyMd5) return false
        if (versionId != other.versionId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.GetObjectRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The bucket name containing the object.
         *
         * When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see [Using access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html) in the *Amazon S3 User Guide*.
         *
         * When using an Object Lambda access point the hostname takes the form *AccessPointName*-*AccountId*.s3-object-lambda.*Region*.amazonaws.com.
         *
         * When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form ` <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com`. When using this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
         */
        var bucket: kotlin.String? = null
        /**
         * The account ID of the expected bucket owner. If the bucket is owned by a different account, the request fails with the HTTP status code `403 Forbidden` (access denied).
         */
        var expectedBucketOwner: kotlin.String? = null
        /**
         * Return the object only if its entity tag (ETag) is the same as the one specified; otherwise, return a 412 (precondition failed) error.
         */
        var ifMatch: kotlin.String? = null
        /**
         * Return the object only if it has been modified since the specified time; otherwise, return a 304 (not modified) error.
         */
        var ifModifiedSince: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Return the object only if its entity tag (ETag) is different from the one specified; otherwise, return a 304 (not modified) error.
         */
        var ifNoneMatch: kotlin.String? = null
        /**
         * Return the object only if it has not been modified since the specified time; otherwise, return a 412 (precondition failed) error.
         */
        var ifUnmodifiedSince: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Key of the object to get.
         */
        var key: kotlin.String? = null
        /**
         * Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a 'ranged' GET request for the part specified. Useful for downloading just a part of an object.
         */
        var partNumber: kotlin.Int = 0
        /**
         * Downloads the specified range bytes of an object. For more information about the HTTP Range header, see [https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35](https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35).
         *
         * Amazon S3 doesn't support retrieving multiple ranges of data per `GET` request.
         */
        var range: kotlin.String? = null
        /**
         * Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from Requester Pays buckets, see [Downloading Objects in Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html) in the *Amazon S3 User Guide*.
         */
        var requestPayer: aws.sdk.kotlin.services.s3.model.RequestPayer? = null
        /**
         * Sets the `Cache-Control` header of the response.
         */
        var responseCacheControl: kotlin.String? = null
        /**
         * Sets the `Content-Disposition` header of the response
         */
        var responseContentDisposition: kotlin.String? = null
        /**
         * Sets the `Content-Encoding` header of the response.
         */
        var responseContentEncoding: kotlin.String? = null
        /**
         * Sets the `Content-Language` header of the response.
         */
        var responseContentLanguage: kotlin.String? = null
        /**
         * Sets the `Content-Type` header of the response.
         */
        var responseContentType: kotlin.String? = null
        /**
         * Sets the `Expires` header of the response.
         */
        var responseExpires: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the algorithm to use to when decrypting the object (for example, AES256).
         */
        var sseCustomerAlgorithm: kotlin.String? = null
        /**
         * Specifies the customer-provided encryption key for Amazon S3 used to encrypt the data. This value is used to decrypt the object when recovering it and must match the one used when storing the data. The key must be appropriate for use with the algorithm specified in the `x-amz-server-side-encryption-customer-algorithm` header.
         */
        var sseCustomerKey: kotlin.String? = null
        /**
         * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
         */
        var sseCustomerKeyMd5: kotlin.String? = null
        /**
         * VersionId used to reference a specific version of the object.
         */
        var versionId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.GetObjectRequest) : this() {
            this.bucket = x.bucket
            this.expectedBucketOwner = x.expectedBucketOwner
            this.ifMatch = x.ifMatch
            this.ifModifiedSince = x.ifModifiedSince
            this.ifNoneMatch = x.ifNoneMatch
            this.ifUnmodifiedSince = x.ifUnmodifiedSince
            this.key = x.key
            this.partNumber = x.partNumber
            this.range = x.range
            this.requestPayer = x.requestPayer
            this.responseCacheControl = x.responseCacheControl
            this.responseContentDisposition = x.responseContentDisposition
            this.responseContentEncoding = x.responseContentEncoding
            this.responseContentLanguage = x.responseContentLanguage
            this.responseContentType = x.responseContentType
            this.responseExpires = x.responseExpires
            this.sseCustomerAlgorithm = x.sseCustomerAlgorithm
            this.sseCustomerKey = x.sseCustomerKey
            this.sseCustomerKeyMd5 = x.sseCustomerKeyMd5
            this.versionId = x.versionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.GetObjectRequest = GetObjectRequest(this)
    }
}
