// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.time.Instant

class HeadObjectRequest private constructor(builder: Builder) {
    /**
     * The name of the bucket containing the object.
     *
     * When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see [Using access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html) in the *Amazon S3 User Guide*.
     *
     * When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form ` <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com`. When using this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
     */
    val bucket: kotlin.String? = requireNotNull(builder.bucket) { "A non-null value must be provided for bucket" }
    /**
     * To retrieve the checksum, this parameter must be enabled.
     *
     * In addition, if you enable `ChecksumMode` and the object is encrypted with Amazon Web Services Key Management Service (Amazon Web Services KMS), you must have permission to use the `kms:Decrypt` action for the request to succeed.
     */
    val checksumMode: aws.sdk.kotlin.services.s3.model.ChecksumMode? = builder.checksumMode
    /**
     * The account ID of the expected bucket owner. If the bucket is owned by a different account, the request fails with the HTTP status code `403 Forbidden` (access denied).
     */
    val expectedBucketOwner: kotlin.String? = builder.expectedBucketOwner
    /**
     * Return the object only if its entity tag (ETag) is the same as the one specified; otherwise, return a 412 (precondition failed) error.
     */
    val ifMatch: kotlin.String? = builder.ifMatch
    /**
     * Return the object only if it has been modified since the specified time; otherwise, return a 304 (not modified) error.
     */
    val ifModifiedSince: aws.smithy.kotlin.runtime.time.Instant? = builder.ifModifiedSince
    /**
     * Return the object only if its entity tag (ETag) is different from the one specified; otherwise, return a 304 (not modified) error.
     */
    val ifNoneMatch: kotlin.String? = builder.ifNoneMatch
    /**
     * Return the object only if it has not been modified since the specified time; otherwise, return a 412 (precondition failed) error.
     */
    val ifUnmodifiedSince: aws.smithy.kotlin.runtime.time.Instant? = builder.ifUnmodifiedSince
    /**
     * The object key.
     */
    val key: kotlin.String? = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a 'ranged' HEAD request for the part specified. Useful querying about the size of the part and the number of parts in this object.
     */
    val partNumber: kotlin.Int = builder.partNumber
    /**
     * Because `HeadObject` returns only the metadata for an object, this parameter has no effect.
     */
    val range: kotlin.String? = builder.range
    /**
     * Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from Requester Pays buckets, see [Downloading Objects in Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html) in the *Amazon S3 User Guide*.
     */
    val requestPayer: aws.sdk.kotlin.services.s3.model.RequestPayer? = builder.requestPayer
    /**
     * Specifies the algorithm to use to when encrypting the object (for example, AES256).
     */
    val sseCustomerAlgorithm: kotlin.String? = builder.sseCustomerAlgorithm
    /**
     * Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the `x-amz-server-side-encryption-customer-algorithm` header.
     */
    val sseCustomerKey: kotlin.String? = builder.sseCustomerKey
    /**
     * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
     */
    val sseCustomerKeyMd5: kotlin.String? = builder.sseCustomerKeyMd5
    /**
     * VersionId used to reference a specific version of the object.
     */
    val versionId: kotlin.String? = builder.versionId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.HeadObjectRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HeadObjectRequest(")
        append("bucket=$bucket,")
        append("checksumMode=$checksumMode,")
        append("expectedBucketOwner=$expectedBucketOwner,")
        append("ifMatch=$ifMatch,")
        append("ifModifiedSince=$ifModifiedSince,")
        append("ifNoneMatch=$ifNoneMatch,")
        append("ifUnmodifiedSince=$ifUnmodifiedSince,")
        append("key=$key,")
        append("partNumber=$partNumber,")
        append("range=$range,")
        append("requestPayer=$requestPayer,")
        append("sseCustomerAlgorithm=$sseCustomerAlgorithm,")
        append("sseCustomerKey=*** Sensitive Data Redacted ***,")
        append("sseCustomerKeyMd5=$sseCustomerKeyMd5,")
        append("versionId=$versionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (checksumMode?.hashCode() ?: 0)
        result = 31 * result + (expectedBucketOwner?.hashCode() ?: 0)
        result = 31 * result + (ifMatch?.hashCode() ?: 0)
        result = 31 * result + (ifModifiedSince?.hashCode() ?: 0)
        result = 31 * result + (ifNoneMatch?.hashCode() ?: 0)
        result = 31 * result + (ifUnmodifiedSince?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (partNumber)
        result = 31 * result + (range?.hashCode() ?: 0)
        result = 31 * result + (requestPayer?.hashCode() ?: 0)
        result = 31 * result + (sseCustomerAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (sseCustomerKey?.hashCode() ?: 0)
        result = 31 * result + (sseCustomerKeyMd5?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HeadObjectRequest

        if (bucket != other.bucket) return false
        if (checksumMode != other.checksumMode) return false
        if (expectedBucketOwner != other.expectedBucketOwner) return false
        if (ifMatch != other.ifMatch) return false
        if (ifModifiedSince != other.ifModifiedSince) return false
        if (ifNoneMatch != other.ifNoneMatch) return false
        if (ifUnmodifiedSince != other.ifUnmodifiedSince) return false
        if (key != other.key) return false
        if (partNumber != other.partNumber) return false
        if (range != other.range) return false
        if (requestPayer != other.requestPayer) return false
        if (sseCustomerAlgorithm != other.sseCustomerAlgorithm) return false
        if (sseCustomerKey != other.sseCustomerKey) return false
        if (sseCustomerKeyMd5 != other.sseCustomerKeyMd5) return false
        if (versionId != other.versionId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.HeadObjectRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the bucket containing the object.
         *
         * When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see [Using access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html) in the *Amazon S3 User Guide*.
         *
         * When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form ` <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com`. When using this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
         */
        var bucket: kotlin.String? = null
        /**
         * To retrieve the checksum, this parameter must be enabled.
         *
         * In addition, if you enable `ChecksumMode` and the object is encrypted with Amazon Web Services Key Management Service (Amazon Web Services KMS), you must have permission to use the `kms:Decrypt` action for the request to succeed.
         */
        var checksumMode: aws.sdk.kotlin.services.s3.model.ChecksumMode? = null
        /**
         * The account ID of the expected bucket owner. If the bucket is owned by a different account, the request fails with the HTTP status code `403 Forbidden` (access denied).
         */
        var expectedBucketOwner: kotlin.String? = null
        /**
         * Return the object only if its entity tag (ETag) is the same as the one specified; otherwise, return a 412 (precondition failed) error.
         */
        var ifMatch: kotlin.String? = null
        /**
         * Return the object only if it has been modified since the specified time; otherwise, return a 304 (not modified) error.
         */
        var ifModifiedSince: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Return the object only if its entity tag (ETag) is different from the one specified; otherwise, return a 304 (not modified) error.
         */
        var ifNoneMatch: kotlin.String? = null
        /**
         * Return the object only if it has not been modified since the specified time; otherwise, return a 412 (precondition failed) error.
         */
        var ifUnmodifiedSince: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The object key.
         */
        var key: kotlin.String? = null
        /**
         * Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a 'ranged' HEAD request for the part specified. Useful querying about the size of the part and the number of parts in this object.
         */
        var partNumber: kotlin.Int = 0
        /**
         * Because `HeadObject` returns only the metadata for an object, this parameter has no effect.
         */
        var range: kotlin.String? = null
        /**
         * Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from Requester Pays buckets, see [Downloading Objects in Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html) in the *Amazon S3 User Guide*.
         */
        var requestPayer: aws.sdk.kotlin.services.s3.model.RequestPayer? = null
        /**
         * Specifies the algorithm to use to when encrypting the object (for example, AES256).
         */
        var sseCustomerAlgorithm: kotlin.String? = null
        /**
         * Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the `x-amz-server-side-encryption-customer-algorithm` header.
         */
        var sseCustomerKey: kotlin.String? = null
        /**
         * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
         */
        var sseCustomerKeyMd5: kotlin.String? = null
        /**
         * VersionId used to reference a specific version of the object.
         */
        var versionId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.HeadObjectRequest) : this() {
            this.bucket = x.bucket
            this.checksumMode = x.checksumMode
            this.expectedBucketOwner = x.expectedBucketOwner
            this.ifMatch = x.ifMatch
            this.ifModifiedSince = x.ifModifiedSince
            this.ifNoneMatch = x.ifNoneMatch
            this.ifUnmodifiedSince = x.ifUnmodifiedSince
            this.key = x.key
            this.partNumber = x.partNumber
            this.range = x.range
            this.requestPayer = x.requestPayer
            this.sseCustomerAlgorithm = x.sseCustomerAlgorithm
            this.sseCustomerKey = x.sseCustomerKey
            this.sseCustomerKeyMd5 = x.sseCustomerKeyMd5
            this.versionId = x.versionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.HeadObjectRequest = HeadObjectRequest(this)
    }
}
