// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.time.Instant

class ListPartsResponse private constructor(builder: Builder) {
    /**
     * If the bucket has a lifecycle rule configured with an action to abort incomplete multipart uploads and the prefix in the lifecycle rule matches the object name in the request, then the response includes this header indicating when the initiated multipart upload will become eligible for abort operation. For more information, see [Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config).
     *
     * The response will also include the `x-amz-abort-rule-id` header that will provide the ID of the lifecycle configuration rule that defines this action.
     */
    val abortDate: aws.smithy.kotlin.runtime.time.Instant? = builder.abortDate
    /**
     * This header is returned along with the `x-amz-abort-date` header. It identifies applicable lifecycle configuration rule that defines the action to abort incomplete multipart uploads.
     */
    val abortRuleId: kotlin.String? = builder.abortRuleId
    /**
     * The name of the bucket to which the multipart upload was initiated. Does not return the access point ARN or access point alias if used.
     */
    val bucket: kotlin.String? = builder.bucket
    /**
     * The algorithm that was used to create a checksum of the object.
     */
    val checksumAlgorithm: aws.sdk.kotlin.services.s3.model.ChecksumAlgorithm? = builder.checksumAlgorithm
    /**
     * Container element that identifies who initiated the multipart upload. If the initiator is an Amazon Web Services account, this element provides the same information as the `Owner` element. If the initiator is an IAM User, this element provides the user ARN and display name.
     */
    val initiator: aws.sdk.kotlin.services.s3.model.Initiator? = builder.initiator
    /**
     * Indicates whether the returned list of parts is truncated. A true value indicates that the list was truncated. A list can be truncated if the number of parts exceeds the limit returned in the MaxParts element.
     */
    val isTruncated: kotlin.Boolean = builder.isTruncated
    /**
     * Object key for which the multipart upload was initiated.
     */
    val key: kotlin.String? = builder.key
    /**
     * Maximum number of parts that were allowed in the response.
     */
    val maxParts: kotlin.Int = builder.maxParts
    /**
     * When a list is truncated, this element specifies the last part in the list, as well as the value to use for the part-number-marker request parameter in a subsequent request.
     */
    val nextPartNumberMarker: kotlin.String? = builder.nextPartNumberMarker
    /**
     * Container element that identifies the object owner, after the object is created. If multipart upload is initiated by an IAM user, this element provides the parent account ID and display name.
     */
    val owner: aws.sdk.kotlin.services.s3.model.Owner? = builder.owner
    /**
     * When a list is truncated, this element specifies the last part in the list, as well as the value to use for the part-number-marker request parameter in a subsequent request.
     */
    val partNumberMarker: kotlin.String? = builder.partNumberMarker
    /**
     * Container for elements related to a particular part. A response can contain zero or more `Part` elements.
     */
    val parts: List<Part>? = builder.parts
    /**
     * If present, indicates that the requester was successfully charged for the request.
     */
    val requestCharged: aws.sdk.kotlin.services.s3.model.RequestCharged? = builder.requestCharged
    /**
     * Class of storage (STANDARD or REDUCED_REDUNDANCY) used to store the uploaded object.
     */
    val storageClass: aws.sdk.kotlin.services.s3.model.StorageClass? = builder.storageClass
    /**
     * Upload ID identifying the multipart upload whose parts are being listed.
     */
    val uploadId: kotlin.String? = builder.uploadId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.ListPartsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListPartsResponse(")
        append("abortDate=$abortDate,")
        append("abortRuleId=$abortRuleId,")
        append("bucket=$bucket,")
        append("checksumAlgorithm=$checksumAlgorithm,")
        append("initiator=$initiator,")
        append("isTruncated=$isTruncated,")
        append("key=$key,")
        append("maxParts=$maxParts,")
        append("nextPartNumberMarker=$nextPartNumberMarker,")
        append("owner=$owner,")
        append("partNumberMarker=$partNumberMarker,")
        append("parts=$parts,")
        append("requestCharged=$requestCharged,")
        append("storageClass=$storageClass,")
        append("uploadId=$uploadId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = abortDate?.hashCode() ?: 0
        result = 31 * result + (abortRuleId?.hashCode() ?: 0)
        result = 31 * result + (bucket?.hashCode() ?: 0)
        result = 31 * result + (checksumAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (initiator?.hashCode() ?: 0)
        result = 31 * result + (isTruncated.hashCode())
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (maxParts)
        result = 31 * result + (nextPartNumberMarker?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (partNumberMarker?.hashCode() ?: 0)
        result = 31 * result + (parts?.hashCode() ?: 0)
        result = 31 * result + (requestCharged?.hashCode() ?: 0)
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        result = 31 * result + (uploadId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListPartsResponse

        if (abortDate != other.abortDate) return false
        if (abortRuleId != other.abortRuleId) return false
        if (bucket != other.bucket) return false
        if (checksumAlgorithm != other.checksumAlgorithm) return false
        if (initiator != other.initiator) return false
        if (isTruncated != other.isTruncated) return false
        if (key != other.key) return false
        if (maxParts != other.maxParts) return false
        if (nextPartNumberMarker != other.nextPartNumberMarker) return false
        if (owner != other.owner) return false
        if (partNumberMarker != other.partNumberMarker) return false
        if (parts != other.parts) return false
        if (requestCharged != other.requestCharged) return false
        if (storageClass != other.storageClass) return false
        if (uploadId != other.uploadId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.ListPartsResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * If the bucket has a lifecycle rule configured with an action to abort incomplete multipart uploads and the prefix in the lifecycle rule matches the object name in the request, then the response includes this header indicating when the initiated multipart upload will become eligible for abort operation. For more information, see [Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config).
         *
         * The response will also include the `x-amz-abort-rule-id` header that will provide the ID of the lifecycle configuration rule that defines this action.
         */
        var abortDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * This header is returned along with the `x-amz-abort-date` header. It identifies applicable lifecycle configuration rule that defines the action to abort incomplete multipart uploads.
         */
        var abortRuleId: kotlin.String? = null
        /**
         * The name of the bucket to which the multipart upload was initiated. Does not return the access point ARN or access point alias if used.
         */
        var bucket: kotlin.String? = null
        /**
         * The algorithm that was used to create a checksum of the object.
         */
        var checksumAlgorithm: aws.sdk.kotlin.services.s3.model.ChecksumAlgorithm? = null
        /**
         * Container element that identifies who initiated the multipart upload. If the initiator is an Amazon Web Services account, this element provides the same information as the `Owner` element. If the initiator is an IAM User, this element provides the user ARN and display name.
         */
        var initiator: aws.sdk.kotlin.services.s3.model.Initiator? = null
        /**
         * Indicates whether the returned list of parts is truncated. A true value indicates that the list was truncated. A list can be truncated if the number of parts exceeds the limit returned in the MaxParts element.
         */
        var isTruncated: kotlin.Boolean = false
        /**
         * Object key for which the multipart upload was initiated.
         */
        var key: kotlin.String? = null
        /**
         * Maximum number of parts that were allowed in the response.
         */
        var maxParts: kotlin.Int = 0
        /**
         * When a list is truncated, this element specifies the last part in the list, as well as the value to use for the part-number-marker request parameter in a subsequent request.
         */
        var nextPartNumberMarker: kotlin.String? = null
        /**
         * Container element that identifies the object owner, after the object is created. If multipart upload is initiated by an IAM user, this element provides the parent account ID and display name.
         */
        var owner: aws.sdk.kotlin.services.s3.model.Owner? = null
        /**
         * When a list is truncated, this element specifies the last part in the list, as well as the value to use for the part-number-marker request parameter in a subsequent request.
         */
        var partNumberMarker: kotlin.String? = null
        /**
         * Container for elements related to a particular part. A response can contain zero or more `Part` elements.
         */
        var parts: List<Part>? = null
        /**
         * If present, indicates that the requester was successfully charged for the request.
         */
        var requestCharged: aws.sdk.kotlin.services.s3.model.RequestCharged? = null
        /**
         * Class of storage (STANDARD or REDUCED_REDUNDANCY) used to store the uploaded object.
         */
        var storageClass: aws.sdk.kotlin.services.s3.model.StorageClass? = null
        /**
         * Upload ID identifying the multipart upload whose parts are being listed.
         */
        var uploadId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.ListPartsResponse) : this() {
            this.abortDate = x.abortDate
            this.abortRuleId = x.abortRuleId
            this.bucket = x.bucket
            this.checksumAlgorithm = x.checksumAlgorithm
            this.initiator = x.initiator
            this.isTruncated = x.isTruncated
            this.key = x.key
            this.maxParts = x.maxParts
            this.nextPartNumberMarker = x.nextPartNumberMarker
            this.owner = x.owner
            this.partNumberMarker = x.partNumberMarker
            this.parts = x.parts
            this.requestCharged = x.requestCharged
            this.storageClass = x.storageClass
            this.uploadId = x.uploadId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.ListPartsResponse = ListPartsResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.Initiator] inside the given [block]
         */
        fun initiator(block: aws.sdk.kotlin.services.s3.model.Initiator.Builder.() -> kotlin.Unit) {
            this.initiator = aws.sdk.kotlin.services.s3.model.Initiator.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.Owner] inside the given [block]
         */
        fun owner(block: aws.sdk.kotlin.services.s3.model.Owner.Builder.() -> kotlin.Unit) {
            this.owner = aws.sdk.kotlin.services.s3.model.Owner.invoke(block)
        }
    }
}
