// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * Specifies a metrics configuration filter. The metrics configuration only includes objects that meet the filter's criteria. A filter must be a prefix, an object tag, an access point ARN, or a conjunction (MetricsAndOperator). For more information, see [PutBucketMetricsConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketMetricsConfiguration.html).
 */
sealed class MetricsFilter {
    /**
     * The access point ARN used when evaluating a metrics filter.
     */
    data class AccessPointArn(val value: kotlin.String) : aws.sdk.kotlin.services.s3.model.MetricsFilter()
    /**
     * A conjunction (logical AND) of predicates, which is used in evaluating a metrics filter. The operator must have at least two predicates, and an object must match all of the predicates in order for the filter to apply.
     */
    data class And(val value: aws.sdk.kotlin.services.s3.model.MetricsAndOperator) : aws.sdk.kotlin.services.s3.model.MetricsFilter()
    /**
     * The prefix used when evaluating a metrics filter.
     */
    data class Prefix(val value: kotlin.String) : aws.sdk.kotlin.services.s3.model.MetricsFilter()
    /**
     * The tag used when evaluating a metrics filter.
     */
    data class Tag(val value: aws.sdk.kotlin.services.s3.model.Tag) : aws.sdk.kotlin.services.s3.model.MetricsFilter()
    object SdkUnknown : aws.sdk.kotlin.services.s3.model.MetricsFilter()

    /**
     * Casts this [MetricsFilter] as a [AccessPointArn] and retrieves its [kotlin.String] value. Throws an exception if the [MetricsFilter] is not a
     * [AccessPointArn].
     */
    fun asAccessPointArn(): kotlin.String = (this as MetricsFilter.AccessPointArn).value

    /**
     * Casts this [MetricsFilter] as a [AccessPointArn] and retrieves its [kotlin.String] value. Returns null if the [MetricsFilter] is not a [AccessPointArn].
     */
    fun asAccessPointArnOrNull(): kotlin.String? = (this as? MetricsFilter.AccessPointArn)?.value

    /**
     * Casts this [MetricsFilter] as a [And] and retrieves its [aws.sdk.kotlin.services.s3.model.MetricsAndOperator] value. Throws an exception if the [MetricsFilter] is not a
     * [And].
     */
    fun asAnd(): aws.sdk.kotlin.services.s3.model.MetricsAndOperator = (this as MetricsFilter.And).value

    /**
     * Casts this [MetricsFilter] as a [And] and retrieves its [aws.sdk.kotlin.services.s3.model.MetricsAndOperator] value. Returns null if the [MetricsFilter] is not a [And].
     */
    fun asAndOrNull(): aws.sdk.kotlin.services.s3.model.MetricsAndOperator? = (this as? MetricsFilter.And)?.value

    /**
     * Casts this [MetricsFilter] as a [Prefix] and retrieves its [kotlin.String] value. Throws an exception if the [MetricsFilter] is not a
     * [Prefix].
     */
    fun asPrefix(): kotlin.String = (this as MetricsFilter.Prefix).value

    /**
     * Casts this [MetricsFilter] as a [Prefix] and retrieves its [kotlin.String] value. Returns null if the [MetricsFilter] is not a [Prefix].
     */
    fun asPrefixOrNull(): kotlin.String? = (this as? MetricsFilter.Prefix)?.value

    /**
     * Casts this [MetricsFilter] as a [Tag] and retrieves its [aws.sdk.kotlin.services.s3.model.Tag] value. Throws an exception if the [MetricsFilter] is not a
     * [Tag].
     */
    fun asTag(): aws.sdk.kotlin.services.s3.model.Tag = (this as MetricsFilter.Tag).value

    /**
     * Casts this [MetricsFilter] as a [Tag] and retrieves its [aws.sdk.kotlin.services.s3.model.Tag] value. Returns null if the [MetricsFilter] is not a [Tag].
     */
    fun asTagOrNull(): aws.sdk.kotlin.services.s3.model.Tag? = (this as? MetricsFilter.Tag)?.value
}

/**
 * Casts this [MetricsFilter] as a [AccessPointArn] and retrieves its [kotlin.String] value.
 */
val MetricsFilter.AccessPointArn get() = (this as MetricsFilter.AccessPointArn).value

/**
 * Casts this [MetricsFilter] as a [And] and retrieves its [aws.sdk.kotlin.services.s3.model.MetricsAndOperator] value.
 */
val MetricsFilter.And get() = (this as MetricsFilter.And).value

/**
 * Casts this [MetricsFilter] as a [Prefix] and retrieves its [kotlin.String] value.
 */
val MetricsFilter.Prefix get() = (this as MetricsFilter.Prefix).value

/**
 * Casts this [MetricsFilter] as a [Tag] and retrieves its [aws.sdk.kotlin.services.s3.model.Tag] value.
 */
val MetricsFilter.Tag get() = (this as MetricsFilter.Tag).value
