// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import kotlin.collections.List

/**
 * The container element for object ownership for a bucket's ownership controls.
 *
 * BucketOwnerPreferred - Objects uploaded to the bucket change ownership to the bucket owner if the objects are uploaded with the `bucket-owner-full-control` canned ACL.
 *
 * ObjectWriter - The uploading account will own the object if the object is uploaded with the `bucket-owner-full-control` canned ACL.
 *
 * BucketOwnerEnforced - Access control lists (ACLs) are disabled and no longer affect permissions. The bucket owner automatically owns and has full control over every object in the bucket. The bucket only accepts PUT requests that don't specify an ACL or bucket owner full control ACLs, such as the `bucket-owner-full-control` canned ACL or an equivalent form of this ACL expressed in the XML format.
 */
sealed class ObjectOwnership {

    abstract val value: kotlin.String

    object BucketOwnerEnforced : aws.sdk.kotlin.services.s3.model.ObjectOwnership() {
        override val value: kotlin.String = "BucketOwnerEnforced"
        override fun toString(): kotlin.String = value
    }

    object BucketOwnerPreferred : aws.sdk.kotlin.services.s3.model.ObjectOwnership() {
        override val value: kotlin.String = "BucketOwnerPreferred"
        override fun toString(): kotlin.String = value
    }

    object ObjectWriter : aws.sdk.kotlin.services.s3.model.ObjectOwnership() {
        override val value: kotlin.String = "ObjectWriter"
        override fun toString(): kotlin.String = value
    }

    data class SdkUnknown(override val value: kotlin.String) : aws.sdk.kotlin.services.s3.model.ObjectOwnership() {
        override fun toString(): kotlin.String = value
    }

    companion object {
        /**
         * Convert a raw value to one of the sealed variants or [SdkUnknown]
         */
        fun fromValue(str: kotlin.String): aws.sdk.kotlin.services.s3.model.ObjectOwnership = when(str) {
            "BucketOwnerEnforced" -> BucketOwnerEnforced
            "BucketOwnerPreferred" -> BucketOwnerPreferred
            "ObjectWriter" -> ObjectWriter
            else -> SdkUnknown(str)
        }

        /**
         * Get a list of all possible variants
         */
        fun values(): kotlin.collections.List<aws.sdk.kotlin.services.s3.model.ObjectOwnership> = listOf(
            BucketOwnerEnforced,
            BucketOwnerPreferred,
            ObjectWriter
        )
    }
}
