// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The version of an object.
 */
class ObjectVersion private constructor(builder: Builder) {
    /**
     * The algorithm that was used to create a checksum of the object.
     */
    val checksumAlgorithm: List<ChecksumAlgorithm>? = builder.checksumAlgorithm
    /**
     * The entity tag is an MD5 hash of that version of the object.
     */
    val eTag: kotlin.String? = builder.eTag
    /**
     * Specifies whether the object is (true) or is not (false) the latest version of an object.
     */
    val isLatest: kotlin.Boolean = builder.isLatest
    /**
     * The object key.
     */
    val key: kotlin.String? = builder.key
    /**
     * Date and time the object was last modified.
     */
    val lastModified: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModified
    /**
     * Specifies the owner of the object.
     */
    val owner: aws.sdk.kotlin.services.s3.model.Owner? = builder.owner
    /**
     * Size in bytes of the object.
     */
    val size: kotlin.Long = builder.size
    /**
     * The class of storage used to store the object.
     */
    val storageClass: aws.sdk.kotlin.services.s3.model.ObjectVersionStorageClass? = builder.storageClass
    /**
     * Version ID of an object.
     */
    val versionId: kotlin.String? = builder.versionId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.ObjectVersion = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ObjectVersion(")
        append("checksumAlgorithm=$checksumAlgorithm,")
        append("eTag=$eTag,")
        append("isLatest=$isLatest,")
        append("key=$key,")
        append("lastModified=$lastModified,")
        append("owner=$owner,")
        append("size=$size,")
        append("storageClass=$storageClass,")
        append("versionId=$versionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = checksumAlgorithm?.hashCode() ?: 0
        result = 31 * result + (eTag?.hashCode() ?: 0)
        result = 31 * result + (isLatest.hashCode())
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (lastModified?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (size.hashCode())
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ObjectVersion

        if (checksumAlgorithm != other.checksumAlgorithm) return false
        if (eTag != other.eTag) return false
        if (isLatest != other.isLatest) return false
        if (key != other.key) return false
        if (lastModified != other.lastModified) return false
        if (owner != other.owner) return false
        if (size != other.size) return false
        if (storageClass != other.storageClass) return false
        if (versionId != other.versionId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.ObjectVersion = Builder(this).apply(block).build()

    class Builder {
        /**
         * The algorithm that was used to create a checksum of the object.
         */
        var checksumAlgorithm: List<ChecksumAlgorithm>? = null
        /**
         * The entity tag is an MD5 hash of that version of the object.
         */
        var eTag: kotlin.String? = null
        /**
         * Specifies whether the object is (true) or is not (false) the latest version of an object.
         */
        var isLatest: kotlin.Boolean = false
        /**
         * The object key.
         */
        var key: kotlin.String? = null
        /**
         * Date and time the object was last modified.
         */
        var lastModified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the owner of the object.
         */
        var owner: aws.sdk.kotlin.services.s3.model.Owner? = null
        /**
         * Size in bytes of the object.
         */
        var size: kotlin.Long = 0L
        /**
         * The class of storage used to store the object.
         */
        var storageClass: aws.sdk.kotlin.services.s3.model.ObjectVersionStorageClass? = null
        /**
         * Version ID of an object.
         */
        var versionId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.ObjectVersion) : this() {
            this.checksumAlgorithm = x.checksumAlgorithm
            this.eTag = x.eTag
            this.isLatest = x.isLatest
            this.key = x.key
            this.lastModified = x.lastModified
            this.owner = x.owner
            this.size = x.size
            this.storageClass = x.storageClass
            this.versionId = x.versionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.ObjectVersion = ObjectVersion(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.Owner] inside the given [block]
         */
        fun owner(block: aws.sdk.kotlin.services.s3.model.Owner.Builder.() -> kotlin.Unit) {
            this.owner = aws.sdk.kotlin.services.s3.model.Owner.invoke(block)
        }
    }
}
