// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * The container element for an ownership control rule.
 */
class OwnershipControlsRule private constructor(builder: Builder) {
    /**
     * The container element for object ownership for a bucket's ownership controls.
     *
     * BucketOwnerPreferred - Objects uploaded to the bucket change ownership to the bucket owner if the objects are uploaded with the `bucket-owner-full-control` canned ACL.
     *
     * ObjectWriter - The uploading account will own the object if the object is uploaded with the `bucket-owner-full-control` canned ACL.
     *
     * BucketOwnerEnforced - Access control lists (ACLs) are disabled and no longer affect permissions. The bucket owner automatically owns and has full control over every object in the bucket. The bucket only accepts PUT requests that don't specify an ACL or bucket owner full control ACLs, such as the `bucket-owner-full-control` canned ACL or an equivalent form of this ACL expressed in the XML format.
     */
    val objectOwnership: aws.sdk.kotlin.services.s3.model.ObjectOwnership? = builder.objectOwnership

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.OwnershipControlsRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OwnershipControlsRule(")
        append("objectOwnership=$objectOwnership)")
    }

    override fun hashCode(): kotlin.Int {
        var result = objectOwnership?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OwnershipControlsRule

        if (objectOwnership != other.objectOwnership) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.OwnershipControlsRule = Builder(this).apply(block).build()

    class Builder {
        /**
         * The container element for object ownership for a bucket's ownership controls.
         *
         * BucketOwnerPreferred - Objects uploaded to the bucket change ownership to the bucket owner if the objects are uploaded with the `bucket-owner-full-control` canned ACL.
         *
         * ObjectWriter - The uploading account will own the object if the object is uploaded with the `bucket-owner-full-control` canned ACL.
         *
         * BucketOwnerEnforced - Access control lists (ACLs) are disabled and no longer affect permissions. The bucket owner automatically owns and has full control over every object in the bucket. The bucket only accepts PUT requests that don't specify an ACL or bucket owner full control ACLs, such as the `bucket-owner-full-control` canned ACL or an equivalent form of this ACL expressed in the XML format.
         */
        var objectOwnership: aws.sdk.kotlin.services.s3.model.ObjectOwnership? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.OwnershipControlsRule) : this() {
            this.objectOwnership = x.objectOwnership
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.OwnershipControlsRule = OwnershipControlsRule(this)
    }
}
