// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Container for elements related to a part.
 */
class Part private constructor(builder: Builder) {
    /**
     * This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This header specifies the base64-encoded, 32-bit CRC32 checksum of the object. For more information, see [Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html) in the *Amazon S3 User Guide*.
     */
    val checksumCrc32: kotlin.String? = builder.checksumCrc32
    /**
     * The base64-encoded, 32-bit CRC32C checksum of the object. This will only be present if it was uploaded with the object. With multipart uploads, this may not be a checksum value of the object. For more information about how checksums are calculated with multipart uploads, see [ Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums) in the *Amazon S3 User Guide*.
     */
    val checksumCrc32C: kotlin.String? = builder.checksumCrc32C
    /**
     * The base64-encoded, 160-bit SHA-1 digest of the object. This will only be present if it was uploaded with the object. With multipart uploads, this may not be a checksum value of the object. For more information about how checksums are calculated with multipart uploads, see [ Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums) in the *Amazon S3 User Guide*.
     */
    val checksumSha1: kotlin.String? = builder.checksumSha1
    /**
     * This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This header specifies the base64-encoded, 256-bit SHA-256 digest of the object. For more information, see [Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html) in the *Amazon S3 User Guide*.
     */
    val checksumSha256: kotlin.String? = builder.checksumSha256
    /**
     * Entity tag returned when the part was uploaded.
     */
    val eTag: kotlin.String? = builder.eTag
    /**
     * Date and time at which the part was uploaded.
     */
    val lastModified: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModified
    /**
     * Part number identifying the part. This is a positive integer between 1 and 10,000.
     */
    val partNumber: kotlin.Int = builder.partNumber
    /**
     * Size in bytes of the uploaded part data.
     */
    val size: kotlin.Long = builder.size

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.Part = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Part(")
        append("checksumCrc32=$checksumCrc32,")
        append("checksumCrc32C=$checksumCrc32C,")
        append("checksumSha1=$checksumSha1,")
        append("checksumSha256=$checksumSha256,")
        append("eTag=$eTag,")
        append("lastModified=$lastModified,")
        append("partNumber=$partNumber,")
        append("size=$size)")
    }

    override fun hashCode(): kotlin.Int {
        var result = checksumCrc32?.hashCode() ?: 0
        result = 31 * result + (checksumCrc32C?.hashCode() ?: 0)
        result = 31 * result + (checksumSha1?.hashCode() ?: 0)
        result = 31 * result + (checksumSha256?.hashCode() ?: 0)
        result = 31 * result + (eTag?.hashCode() ?: 0)
        result = 31 * result + (lastModified?.hashCode() ?: 0)
        result = 31 * result + (partNumber)
        result = 31 * result + (size.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Part

        if (checksumCrc32 != other.checksumCrc32) return false
        if (checksumCrc32C != other.checksumCrc32C) return false
        if (checksumSha1 != other.checksumSha1) return false
        if (checksumSha256 != other.checksumSha256) return false
        if (eTag != other.eTag) return false
        if (lastModified != other.lastModified) return false
        if (partNumber != other.partNumber) return false
        if (size != other.size) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.Part = Builder(this).apply(block).build()

    class Builder {
        /**
         * This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This header specifies the base64-encoded, 32-bit CRC32 checksum of the object. For more information, see [Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html) in the *Amazon S3 User Guide*.
         */
        var checksumCrc32: kotlin.String? = null
        /**
         * The base64-encoded, 32-bit CRC32C checksum of the object. This will only be present if it was uploaded with the object. With multipart uploads, this may not be a checksum value of the object. For more information about how checksums are calculated with multipart uploads, see [ Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums) in the *Amazon S3 User Guide*.
         */
        var checksumCrc32C: kotlin.String? = null
        /**
         * The base64-encoded, 160-bit SHA-1 digest of the object. This will only be present if it was uploaded with the object. With multipart uploads, this may not be a checksum value of the object. For more information about how checksums are calculated with multipart uploads, see [ Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums) in the *Amazon S3 User Guide*.
         */
        var checksumSha1: kotlin.String? = null
        /**
         * This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This header specifies the base64-encoded, 256-bit SHA-256 digest of the object. For more information, see [Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html) in the *Amazon S3 User Guide*.
         */
        var checksumSha256: kotlin.String? = null
        /**
         * Entity tag returned when the part was uploaded.
         */
        var eTag: kotlin.String? = null
        /**
         * Date and time at which the part was uploaded.
         */
        var lastModified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Part number identifying the part. This is a positive integer between 1 and 10,000.
         */
        var partNumber: kotlin.Int = 0
        /**
         * Size in bytes of the uploaded part data.
         */
        var size: kotlin.Long = 0L

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.Part) : this() {
            this.checksumCrc32 = x.checksumCrc32
            this.checksumCrc32C = x.checksumCrc32C
            this.checksumSha1 = x.checksumSha1
            this.checksumSha256 = x.checksumSha256
            this.eTag = x.eTag
            this.lastModified = x.lastModified
            this.partNumber = x.partNumber
            this.size = x.size
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.Part = Part(this)
    }
}
