// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



class PutBucketLoggingRequest private constructor(builder: Builder) {
    /**
     * The name of the bucket for which to set the logging parameters.
     */
    val bucket: kotlin.String? = requireNotNull(builder.bucket) { "A non-null value must be provided for bucket" }
    /**
     * Container for logging status information.
     */
    val bucketLoggingStatus: aws.sdk.kotlin.services.s3.model.BucketLoggingStatus? = builder.bucketLoggingStatus
    /**
     * The MD5 hash of the `PutBucketLogging` request body.
     *
     * For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.
     */
    val contentMd5: kotlin.String? = builder.contentMd5
    /**
     * The account ID of the expected bucket owner. If the bucket is owned by a different account, the request fails with the HTTP status code `403 Forbidden` (access denied).
     */
    val expectedBucketOwner: kotlin.String? = builder.expectedBucketOwner

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.PutBucketLoggingRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutBucketLoggingRequest(")
        append("bucket=$bucket,")
        append("bucketLoggingStatus=$bucketLoggingStatus,")
        append("contentMd5=$contentMd5,")
        append("expectedBucketOwner=$expectedBucketOwner)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (bucketLoggingStatus?.hashCode() ?: 0)
        result = 31 * result + (contentMd5?.hashCode() ?: 0)
        result = 31 * result + (expectedBucketOwner?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutBucketLoggingRequest

        if (bucket != other.bucket) return false
        if (bucketLoggingStatus != other.bucketLoggingStatus) return false
        if (contentMd5 != other.contentMd5) return false
        if (expectedBucketOwner != other.expectedBucketOwner) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.PutBucketLoggingRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the bucket for which to set the logging parameters.
         */
        var bucket: kotlin.String? = null
        /**
         * Container for logging status information.
         */
        var bucketLoggingStatus: aws.sdk.kotlin.services.s3.model.BucketLoggingStatus? = null
        /**
         * The MD5 hash of the `PutBucketLogging` request body.
         *
         * For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.
         */
        var contentMd5: kotlin.String? = null
        /**
         * The account ID of the expected bucket owner. If the bucket is owned by a different account, the request fails with the HTTP status code `403 Forbidden` (access denied).
         */
        var expectedBucketOwner: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.PutBucketLoggingRequest) : this() {
            this.bucket = x.bucket
            this.bucketLoggingStatus = x.bucketLoggingStatus
            this.contentMd5 = x.contentMd5
            this.expectedBucketOwner = x.expectedBucketOwner
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.PutBucketLoggingRequest = PutBucketLoggingRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.BucketLoggingStatus] inside the given [block]
         */
        fun bucketLoggingStatus(block: aws.sdk.kotlin.services.s3.model.BucketLoggingStatus.Builder.() -> kotlin.Unit) {
            this.bucketLoggingStatus = aws.sdk.kotlin.services.s3.model.BucketLoggingStatus.invoke(block)
        }
    }
}
