// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



class PutBucketPolicyRequest private constructor(builder: Builder) {
    /**
     * The name of the bucket.
     */
    val bucket: kotlin.String? = requireNotNull(builder.bucket) { "A non-null value must be provided for bucket" }
    /**
     * Set this parameter to true to confirm that you want to remove your permissions to change this bucket policy in the future.
     */
    val confirmRemoveSelfBucketAccess: kotlin.Boolean = builder.confirmRemoveSelfBucketAccess
    /**
     * The MD5 hash of the request body.
     *
     * For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.
     */
    val contentMd5: kotlin.String? = builder.contentMd5
    /**
     * The account ID of the expected bucket owner. If the bucket is owned by a different account, the request fails with the HTTP status code `403 Forbidden` (access denied).
     */
    val expectedBucketOwner: kotlin.String? = builder.expectedBucketOwner
    /**
     * The bucket policy as a JSON document.
     */
    val policy: kotlin.String? = builder.policy

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.PutBucketPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutBucketPolicyRequest(")
        append("bucket=$bucket,")
        append("confirmRemoveSelfBucketAccess=$confirmRemoveSelfBucketAccess,")
        append("contentMd5=$contentMd5,")
        append("expectedBucketOwner=$expectedBucketOwner,")
        append("policy=$policy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (confirmRemoveSelfBucketAccess.hashCode())
        result = 31 * result + (contentMd5?.hashCode() ?: 0)
        result = 31 * result + (expectedBucketOwner?.hashCode() ?: 0)
        result = 31 * result + (policy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutBucketPolicyRequest

        if (bucket != other.bucket) return false
        if (confirmRemoveSelfBucketAccess != other.confirmRemoveSelfBucketAccess) return false
        if (contentMd5 != other.contentMd5) return false
        if (expectedBucketOwner != other.expectedBucketOwner) return false
        if (policy != other.policy) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.PutBucketPolicyRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the bucket.
         */
        var bucket: kotlin.String? = null
        /**
         * Set this parameter to true to confirm that you want to remove your permissions to change this bucket policy in the future.
         */
        var confirmRemoveSelfBucketAccess: kotlin.Boolean = false
        /**
         * The MD5 hash of the request body.
         *
         * For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.
         */
        var contentMd5: kotlin.String? = null
        /**
         * The account ID of the expected bucket owner. If the bucket is owned by a different account, the request fails with the HTTP status code `403 Forbidden` (access denied).
         */
        var expectedBucketOwner: kotlin.String? = null
        /**
         * The bucket policy as a JSON document.
         */
        var policy: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.PutBucketPolicyRequest) : this() {
            this.bucket = x.bucket
            this.confirmRemoveSelfBucketAccess = x.confirmRemoveSelfBucketAccess
            this.contentMd5 = x.contentMd5
            this.expectedBucketOwner = x.expectedBucketOwner
            this.policy = x.policy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.PutBucketPolicyRequest = PutBucketPolicyRequest(this)
    }
}
