// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



class PutBucketVersioningRequest private constructor(builder: Builder) {
    /**
     * The bucket name.
     */
    val bucket: kotlin.String? = requireNotNull(builder.bucket) { "A non-null value must be provided for bucket" }
    /**
     * >The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see [RFC 1864](http://www.ietf.org/rfc/rfc1864.txt).
     *
     * For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.
     */
    val contentMd5: kotlin.String? = builder.contentMd5
    /**
     * The account ID of the expected bucket owner. If the bucket is owned by a different account, the request fails with the HTTP status code `403 Forbidden` (access denied).
     */
    val expectedBucketOwner: kotlin.String? = builder.expectedBucketOwner
    /**
     * The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device.
     */
    val mfa: kotlin.String? = builder.mfa
    /**
     * Container for setting the versioning state.
     */
    val versioningConfiguration: aws.sdk.kotlin.services.s3.model.VersioningConfiguration? = builder.versioningConfiguration

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.PutBucketVersioningRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutBucketVersioningRequest(")
        append("bucket=$bucket,")
        append("contentMd5=$contentMd5,")
        append("expectedBucketOwner=$expectedBucketOwner,")
        append("mfa=$mfa,")
        append("versioningConfiguration=$versioningConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (contentMd5?.hashCode() ?: 0)
        result = 31 * result + (expectedBucketOwner?.hashCode() ?: 0)
        result = 31 * result + (mfa?.hashCode() ?: 0)
        result = 31 * result + (versioningConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutBucketVersioningRequest

        if (bucket != other.bucket) return false
        if (contentMd5 != other.contentMd5) return false
        if (expectedBucketOwner != other.expectedBucketOwner) return false
        if (mfa != other.mfa) return false
        if (versioningConfiguration != other.versioningConfiguration) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.PutBucketVersioningRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The bucket name.
         */
        var bucket: kotlin.String? = null
        /**
         * >The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see [RFC 1864](http://www.ietf.org/rfc/rfc1864.txt).
         *
         * For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.
         */
        var contentMd5: kotlin.String? = null
        /**
         * The account ID of the expected bucket owner. If the bucket is owned by a different account, the request fails with the HTTP status code `403 Forbidden` (access denied).
         */
        var expectedBucketOwner: kotlin.String? = null
        /**
         * The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device.
         */
        var mfa: kotlin.String? = null
        /**
         * Container for setting the versioning state.
         */
        var versioningConfiguration: aws.sdk.kotlin.services.s3.model.VersioningConfiguration? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.PutBucketVersioningRequest) : this() {
            this.bucket = x.bucket
            this.contentMd5 = x.contentMd5
            this.expectedBucketOwner = x.expectedBucketOwner
            this.mfa = x.mfa
            this.versioningConfiguration = x.versioningConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.PutBucketVersioningRequest = PutBucketVersioningRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.VersioningConfiguration] inside the given [block]
         */
        fun versioningConfiguration(block: aws.sdk.kotlin.services.s3.model.VersioningConfiguration.Builder.() -> kotlin.Unit) {
            this.versioningConfiguration = aws.sdk.kotlin.services.s3.model.VersioningConfiguration.invoke(block)
        }
    }
}
