// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



class PutPublicAccessBlockRequest private constructor(builder: Builder) {
    /**
     * The name of the Amazon S3 bucket whose `PublicAccessBlock` configuration you want to set.
     */
    val bucket: kotlin.String? = requireNotNull(builder.bucket) { "A non-null value must be provided for bucket" }
    /**
     * The MD5 hash of the `PutPublicAccessBlock` request body.
     *
     * For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.
     */
    val contentMd5: kotlin.String? = builder.contentMd5
    /**
     * The account ID of the expected bucket owner. If the bucket is owned by a different account, the request fails with the HTTP status code `403 Forbidden` (access denied).
     */
    val expectedBucketOwner: kotlin.String? = builder.expectedBucketOwner
    /**
     * The `PublicAccessBlock` configuration that you want to apply to this Amazon S3 bucket. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see [The Meaning of "Public"](https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status) in the *Amazon S3 User Guide*.
     */
    val publicAccessBlockConfiguration: aws.sdk.kotlin.services.s3.model.PublicAccessBlockConfiguration? = builder.publicAccessBlockConfiguration

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.PutPublicAccessBlockRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutPublicAccessBlockRequest(")
        append("bucket=$bucket,")
        append("contentMd5=$contentMd5,")
        append("expectedBucketOwner=$expectedBucketOwner,")
        append("publicAccessBlockConfiguration=$publicAccessBlockConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (contentMd5?.hashCode() ?: 0)
        result = 31 * result + (expectedBucketOwner?.hashCode() ?: 0)
        result = 31 * result + (publicAccessBlockConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutPublicAccessBlockRequest

        if (bucket != other.bucket) return false
        if (contentMd5 != other.contentMd5) return false
        if (expectedBucketOwner != other.expectedBucketOwner) return false
        if (publicAccessBlockConfiguration != other.publicAccessBlockConfiguration) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.PutPublicAccessBlockRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the Amazon S3 bucket whose `PublicAccessBlock` configuration you want to set.
         */
        var bucket: kotlin.String? = null
        /**
         * The MD5 hash of the `PutPublicAccessBlock` request body.
         *
         * For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.
         */
        var contentMd5: kotlin.String? = null
        /**
         * The account ID of the expected bucket owner. If the bucket is owned by a different account, the request fails with the HTTP status code `403 Forbidden` (access denied).
         */
        var expectedBucketOwner: kotlin.String? = null
        /**
         * The `PublicAccessBlock` configuration that you want to apply to this Amazon S3 bucket. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see [The Meaning of "Public"](https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status) in the *Amazon S3 User Guide*.
         */
        var publicAccessBlockConfiguration: aws.sdk.kotlin.services.s3.model.PublicAccessBlockConfiguration? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.PutPublicAccessBlockRequest) : this() {
            this.bucket = x.bucket
            this.contentMd5 = x.contentMd5
            this.expectedBucketOwner = x.expectedBucketOwner
            this.publicAccessBlockConfiguration = x.publicAccessBlockConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.PutPublicAccessBlockRequest = PutPublicAccessBlockRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.PublicAccessBlockConfiguration] inside the given [block]
         */
        fun publicAccessBlockConfiguration(block: aws.sdk.kotlin.services.s3.model.PublicAccessBlockConfiguration.Builder.() -> kotlin.Unit) {
            this.publicAccessBlockConfiguration = aws.sdk.kotlin.services.s3.model.PublicAccessBlockConfiguration.invoke(block)
        }
    }
}
