// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * Specifies which Amazon S3 objects to replicate and where to store the replicas.
 */
class ReplicationRule private constructor(builder: Builder) {
    /**
     * Specifies whether Amazon S3 replicates delete markers. If you specify a `Filter` in your replication configuration, you must also include a `DeleteMarkerReplication` element. If your `Filter` includes a `Tag` element, the `DeleteMarkerReplication``Status` must be set to Disabled, because Amazon S3 does not support replicating delete markers for tag-based rules. For an example configuration, see [Basic Rule Configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-config-min-rule-config).
     *
     * For more information about delete marker replication, see [Basic Rule Configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/delete-marker-replication.html).
     *
     * If you are using an earlier version of the replication configuration, Amazon S3 handles replication of delete markers differently. For more information, see [Backward Compatibility](https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations).
     */
    val deleteMarkerReplication: aws.sdk.kotlin.services.s3.model.DeleteMarkerReplication? = builder.deleteMarkerReplication
    /**
     * A container for information about the replication destination and its configurations including enabling the S3 Replication Time Control (S3 RTC).
     */
    val destination: aws.sdk.kotlin.services.s3.model.Destination? = builder.destination
    /**
     *
     */
    val existingObjectReplication: aws.sdk.kotlin.services.s3.model.ExistingObjectReplication? = builder.existingObjectReplication
    /**
     * A filter that identifies the subset of objects to which the replication rule applies. A `Filter` must specify exactly one `Prefix`, `Tag`, or an `And` child element.
     */
    val filter: aws.sdk.kotlin.services.s3.model.ReplicationRuleFilter? = builder.filter
    /**
     * A unique identifier for the rule. The maximum value is 255 characters.
     */
    val id: kotlin.String? = builder.id
    /**
     * An object key name prefix that identifies the object or objects to which the rule applies. The maximum prefix length is 1,024 characters. To include all objects in a bucket, specify an empty string.
     *
     * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [ XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    val prefix: kotlin.String? = builder.prefix
    /**
     * The priority indicates which rule has precedence whenever two or more replication rules conflict. Amazon S3 will attempt to replicate objects according to all replication rules. However, if there are two or more rules with the same destination bucket, then objects will be replicated according to the rule with the highest priority. The higher the number, the higher the priority.
     *
     * For more information, see [Replication](https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html) in the *Amazon S3 User Guide*.
     */
    val priority: kotlin.Int = builder.priority
    /**
     * A container that describes additional filters for identifying the source objects that you want to replicate. You can choose to enable or disable the replication of these objects. Currently, Amazon S3 supports only the filter that you can specify for objects created with server-side encryption using a customer managed key stored in Amazon Web Services Key Management Service (SSE-KMS).
     */
    val sourceSelectionCriteria: aws.sdk.kotlin.services.s3.model.SourceSelectionCriteria? = builder.sourceSelectionCriteria
    /**
     * Specifies whether the rule is enabled.
     */
    val status: aws.sdk.kotlin.services.s3.model.ReplicationRuleStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.ReplicationRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicationRule(")
        append("deleteMarkerReplication=$deleteMarkerReplication,")
        append("destination=$destination,")
        append("existingObjectReplication=$existingObjectReplication,")
        append("filter=$filter,")
        append("id=$id,")
        append("prefix=$prefix,")
        append("priority=$priority,")
        append("sourceSelectionCriteria=$sourceSelectionCriteria,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deleteMarkerReplication?.hashCode() ?: 0
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (existingObjectReplication?.hashCode() ?: 0)
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (priority)
        result = 31 * result + (sourceSelectionCriteria?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicationRule

        if (deleteMarkerReplication != other.deleteMarkerReplication) return false
        if (destination != other.destination) return false
        if (existingObjectReplication != other.existingObjectReplication) return false
        if (filter != other.filter) return false
        if (id != other.id) return false
        if (prefix != other.prefix) return false
        if (priority != other.priority) return false
        if (sourceSelectionCriteria != other.sourceSelectionCriteria) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.ReplicationRule = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies whether Amazon S3 replicates delete markers. If you specify a `Filter` in your replication configuration, you must also include a `DeleteMarkerReplication` element. If your `Filter` includes a `Tag` element, the `DeleteMarkerReplication``Status` must be set to Disabled, because Amazon S3 does not support replicating delete markers for tag-based rules. For an example configuration, see [Basic Rule Configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-config-min-rule-config).
         *
         * For more information about delete marker replication, see [Basic Rule Configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/delete-marker-replication.html).
         *
         * If you are using an earlier version of the replication configuration, Amazon S3 handles replication of delete markers differently. For more information, see [Backward Compatibility](https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations).
         */
        var deleteMarkerReplication: aws.sdk.kotlin.services.s3.model.DeleteMarkerReplication? = null
        /**
         * A container for information about the replication destination and its configurations including enabling the S3 Replication Time Control (S3 RTC).
         */
        var destination: aws.sdk.kotlin.services.s3.model.Destination? = null
        /**
         *
         */
        var existingObjectReplication: aws.sdk.kotlin.services.s3.model.ExistingObjectReplication? = null
        /**
         * A filter that identifies the subset of objects to which the replication rule applies. A `Filter` must specify exactly one `Prefix`, `Tag`, or an `And` child element.
         */
        var filter: aws.sdk.kotlin.services.s3.model.ReplicationRuleFilter? = null
        /**
         * A unique identifier for the rule. The maximum value is 255 characters.
         */
        var id: kotlin.String? = null
        /**
         * An object key name prefix that identifies the object or objects to which the rule applies. The maximum prefix length is 1,024 characters. To include all objects in a bucket, specify an empty string.
         *
         * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [ XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        var prefix: kotlin.String? = null
        /**
         * The priority indicates which rule has precedence whenever two or more replication rules conflict. Amazon S3 will attempt to replicate objects according to all replication rules. However, if there are two or more rules with the same destination bucket, then objects will be replicated according to the rule with the highest priority. The higher the number, the higher the priority.
         *
         * For more information, see [Replication](https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html) in the *Amazon S3 User Guide*.
         */
        var priority: kotlin.Int = 0
        /**
         * A container that describes additional filters for identifying the source objects that you want to replicate. You can choose to enable or disable the replication of these objects. Currently, Amazon S3 supports only the filter that you can specify for objects created with server-side encryption using a customer managed key stored in Amazon Web Services Key Management Service (SSE-KMS).
         */
        var sourceSelectionCriteria: aws.sdk.kotlin.services.s3.model.SourceSelectionCriteria? = null
        /**
         * Specifies whether the rule is enabled.
         */
        var status: aws.sdk.kotlin.services.s3.model.ReplicationRuleStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.ReplicationRule) : this() {
            this.deleteMarkerReplication = x.deleteMarkerReplication
            this.destination = x.destination
            this.existingObjectReplication = x.existingObjectReplication
            this.filter = x.filter
            this.id = x.id
            this.prefix = x.prefix
            this.priority = x.priority
            this.sourceSelectionCriteria = x.sourceSelectionCriteria
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.ReplicationRule = ReplicationRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.DeleteMarkerReplication] inside the given [block]
         */
        fun deleteMarkerReplication(block: aws.sdk.kotlin.services.s3.model.DeleteMarkerReplication.Builder.() -> kotlin.Unit) {
            this.deleteMarkerReplication = aws.sdk.kotlin.services.s3.model.DeleteMarkerReplication.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.Destination] inside the given [block]
         */
        fun destination(block: aws.sdk.kotlin.services.s3.model.Destination.Builder.() -> kotlin.Unit) {
            this.destination = aws.sdk.kotlin.services.s3.model.Destination.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.ExistingObjectReplication] inside the given [block]
         */
        fun existingObjectReplication(block: aws.sdk.kotlin.services.s3.model.ExistingObjectReplication.Builder.() -> kotlin.Unit) {
            this.existingObjectReplication = aws.sdk.kotlin.services.s3.model.ExistingObjectReplication.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.SourceSelectionCriteria] inside the given [block]
         */
        fun sourceSelectionCriteria(block: aws.sdk.kotlin.services.s3.model.SourceSelectionCriteria.Builder.() -> kotlin.Unit) {
            this.sourceSelectionCriteria = aws.sdk.kotlin.services.s3.model.SourceSelectionCriteria.invoke(block)
        }
    }
}
