// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * A filter that identifies the subset of objects to which the replication rule applies. A `Filter` must specify exactly one `Prefix`, `Tag`, or an `And` child element.
 */
sealed class ReplicationRuleFilter {
    /**
     * A container for specifying rule filters. The filters determine the subset of objects to which the rule applies. This element is required only if you specify more than one filter. For example:
     * + If you specify both a `Prefix` and a `Tag` filter, wrap these filters in an `And` tag.
     * + If you specify a filter based on multiple tags, wrap the `Tag` elements in an `And` tag.
     */
    data class And(val value: aws.sdk.kotlin.services.s3.model.ReplicationRuleAndOperator) : aws.sdk.kotlin.services.s3.model.ReplicationRuleFilter()
    /**
     * An object key name prefix that identifies the subset of objects to which the rule applies.
     *
     * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [ XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
     */
    data class Prefix(val value: kotlin.String) : aws.sdk.kotlin.services.s3.model.ReplicationRuleFilter()
    /**
     * A container for specifying a tag key and value.
     *
     * The rule applies only to objects that have the tag in their tag set.
     */
    data class Tag(val value: aws.sdk.kotlin.services.s3.model.Tag) : aws.sdk.kotlin.services.s3.model.ReplicationRuleFilter()
    object SdkUnknown : aws.sdk.kotlin.services.s3.model.ReplicationRuleFilter()

    /**
     * Casts this [ReplicationRuleFilter] as a [And] and retrieves its [aws.sdk.kotlin.services.s3.model.ReplicationRuleAndOperator] value. Throws an exception if the [ReplicationRuleFilter] is not a
     * [And].
     */
    fun asAnd(): aws.sdk.kotlin.services.s3.model.ReplicationRuleAndOperator = (this as ReplicationRuleFilter.And).value

    /**
     * Casts this [ReplicationRuleFilter] as a [And] and retrieves its [aws.sdk.kotlin.services.s3.model.ReplicationRuleAndOperator] value. Returns null if the [ReplicationRuleFilter] is not a [And].
     */
    fun asAndOrNull(): aws.sdk.kotlin.services.s3.model.ReplicationRuleAndOperator? = (this as? ReplicationRuleFilter.And)?.value

    /**
     * Casts this [ReplicationRuleFilter] as a [Prefix] and retrieves its [kotlin.String] value. Throws an exception if the [ReplicationRuleFilter] is not a
     * [Prefix].
     */
    fun asPrefix(): kotlin.String = (this as ReplicationRuleFilter.Prefix).value

    /**
     * Casts this [ReplicationRuleFilter] as a [Prefix] and retrieves its [kotlin.String] value. Returns null if the [ReplicationRuleFilter] is not a [Prefix].
     */
    fun asPrefixOrNull(): kotlin.String? = (this as? ReplicationRuleFilter.Prefix)?.value

    /**
     * Casts this [ReplicationRuleFilter] as a [Tag] and retrieves its [aws.sdk.kotlin.services.s3.model.Tag] value. Throws an exception if the [ReplicationRuleFilter] is not a
     * [Tag].
     */
    fun asTag(): aws.sdk.kotlin.services.s3.model.Tag = (this as ReplicationRuleFilter.Tag).value

    /**
     * Casts this [ReplicationRuleFilter] as a [Tag] and retrieves its [aws.sdk.kotlin.services.s3.model.Tag] value. Returns null if the [ReplicationRuleFilter] is not a [Tag].
     */
    fun asTagOrNull(): aws.sdk.kotlin.services.s3.model.Tag? = (this as? ReplicationRuleFilter.Tag)?.value
}

/**
 * Casts this [ReplicationRuleFilter] as a [And] and retrieves its [aws.sdk.kotlin.services.s3.model.ReplicationRuleAndOperator] value.
 */
val ReplicationRuleFilter.And get() = (this as ReplicationRuleFilter.And).value

/**
 * Casts this [ReplicationRuleFilter] as a [Prefix] and retrieves its [kotlin.String] value.
 */
val ReplicationRuleFilter.Prefix get() = (this as ReplicationRuleFilter.Prefix).value

/**
 * Casts this [ReplicationRuleFilter] as a [Tag] and retrieves its [aws.sdk.kotlin.services.s3.model.Tag] value.
 */
val ReplicationRuleFilter.Tag get() = (this as ReplicationRuleFilter.Tag).value
