// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * Describes an Amazon S3 location that will receive the results of the restore request.
 */
class S3Location private constructor(builder: Builder) {
    /**
     * A list of grants that control access to the staged results.
     */
    val accessControlList: List<Grant>? = builder.accessControlList
    /**
     * The name of the bucket where the restore results will be placed.
     */
    val bucketName: kotlin.String? = builder.bucketName
    /**
     * The canned ACL to apply to the restore results.
     */
    val cannedAcl: aws.sdk.kotlin.services.s3.model.ObjectCannedAcl? = builder.cannedAcl
    /**
     * Contains the type of server-side encryption used.
     */
    val encryption: aws.sdk.kotlin.services.s3.model.Encryption? = builder.encryption
    /**
     * The prefix that is prepended to the restore results for this request.
     */
    val prefix: kotlin.String? = builder.prefix
    /**
     * The class of storage used to store the restore results.
     */
    val storageClass: aws.sdk.kotlin.services.s3.model.StorageClass? = builder.storageClass
    /**
     * The tag-set that is applied to the restore results.
     */
    val tagging: aws.sdk.kotlin.services.s3.model.Tagging? = builder.tagging
    /**
     * A list of metadata to store with the restore results in S3.
     */
    val userMetadata: List<MetadataEntry>? = builder.userMetadata

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.S3Location = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Location(")
        append("accessControlList=$accessControlList,")
        append("bucketName=$bucketName,")
        append("cannedAcl=$cannedAcl,")
        append("encryption=$encryption,")
        append("prefix=$prefix,")
        append("storageClass=$storageClass,")
        append("tagging=$tagging,")
        append("userMetadata=$userMetadata)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessControlList?.hashCode() ?: 0
        result = 31 * result + (bucketName?.hashCode() ?: 0)
        result = 31 * result + (cannedAcl?.hashCode() ?: 0)
        result = 31 * result + (encryption?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        result = 31 * result + (tagging?.hashCode() ?: 0)
        result = 31 * result + (userMetadata?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Location

        if (accessControlList != other.accessControlList) return false
        if (bucketName != other.bucketName) return false
        if (cannedAcl != other.cannedAcl) return false
        if (encryption != other.encryption) return false
        if (prefix != other.prefix) return false
        if (storageClass != other.storageClass) return false
        if (tagging != other.tagging) return false
        if (userMetadata != other.userMetadata) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.S3Location = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of grants that control access to the staged results.
         */
        var accessControlList: List<Grant>? = null
        /**
         * The name of the bucket where the restore results will be placed.
         */
        var bucketName: kotlin.String? = null
        /**
         * The canned ACL to apply to the restore results.
         */
        var cannedAcl: aws.sdk.kotlin.services.s3.model.ObjectCannedAcl? = null
        /**
         * Contains the type of server-side encryption used.
         */
        var encryption: aws.sdk.kotlin.services.s3.model.Encryption? = null
        /**
         * The prefix that is prepended to the restore results for this request.
         */
        var prefix: kotlin.String? = null
        /**
         * The class of storage used to store the restore results.
         */
        var storageClass: aws.sdk.kotlin.services.s3.model.StorageClass? = null
        /**
         * The tag-set that is applied to the restore results.
         */
        var tagging: aws.sdk.kotlin.services.s3.model.Tagging? = null
        /**
         * A list of metadata to store with the restore results in S3.
         */
        var userMetadata: List<MetadataEntry>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.S3Location) : this() {
            this.accessControlList = x.accessControlList
            this.bucketName = x.bucketName
            this.cannedAcl = x.cannedAcl
            this.encryption = x.encryption
            this.prefix = x.prefix
            this.storageClass = x.storageClass
            this.tagging = x.tagging
            this.userMetadata = x.userMetadata
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.S3Location = S3Location(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.Encryption] inside the given [block]
         */
        fun encryption(block: aws.sdk.kotlin.services.s3.model.Encryption.Builder.() -> kotlin.Unit) {
            this.encryption = aws.sdk.kotlin.services.s3.model.Encryption.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.Tagging] inside the given [block]
         */
        fun tagging(block: aws.sdk.kotlin.services.s3.model.Tagging.Builder.() -> kotlin.Unit) {
            this.tagging = aws.sdk.kotlin.services.s3.model.Tagging.invoke(block)
        }
    }
}
