// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * Specifies the default server-side encryption configuration.
 */
class ServerSideEncryptionRule private constructor(builder: Builder) {
    /**
     * Specifies the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.
     */
    val applyServerSideEncryptionByDefault: aws.sdk.kotlin.services.s3.model.ServerSideEncryptionByDefault? = builder.applyServerSideEncryptionByDefault
    /**
     * Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket. Existing objects are not affected. Setting the `BucketKeyEnabled` element to `true` causes Amazon S3 to use an S3 Bucket Key. By default, S3 Bucket Key is not enabled.
     *
     * For more information, see [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) in the *Amazon S3 User Guide*.
     */
    val bucketKeyEnabled: kotlin.Boolean = builder.bucketKeyEnabled

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.ServerSideEncryptionRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServerSideEncryptionRule(")
        append("applyServerSideEncryptionByDefault=$applyServerSideEncryptionByDefault,")
        append("bucketKeyEnabled=$bucketKeyEnabled)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyServerSideEncryptionByDefault?.hashCode() ?: 0
        result = 31 * result + (bucketKeyEnabled.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServerSideEncryptionRule

        if (applyServerSideEncryptionByDefault != other.applyServerSideEncryptionByDefault) return false
        if (bucketKeyEnabled != other.bucketKeyEnabled) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.ServerSideEncryptionRule = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.
         */
        var applyServerSideEncryptionByDefault: aws.sdk.kotlin.services.s3.model.ServerSideEncryptionByDefault? = null
        /**
         * Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket. Existing objects are not affected. Setting the `BucketKeyEnabled` element to `true` causes Amazon S3 to use an S3 Bucket Key. By default, S3 Bucket Key is not enabled.
         *
         * For more information, see [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) in the *Amazon S3 User Guide*.
         */
        var bucketKeyEnabled: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.ServerSideEncryptionRule) : this() {
            this.applyServerSideEncryptionByDefault = x.applyServerSideEncryptionByDefault
            this.bucketKeyEnabled = x.bucketKeyEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.ServerSideEncryptionRule = ServerSideEncryptionRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.ServerSideEncryptionByDefault] inside the given [block]
         */
        fun applyServerSideEncryptionByDefault(block: aws.sdk.kotlin.services.s3.model.ServerSideEncryptionByDefault.Builder.() -> kotlin.Unit) {
            this.applyServerSideEncryptionByDefault = aws.sdk.kotlin.services.s3.model.ServerSideEncryptionByDefault.invoke(block)
        }
    }
}
