// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



class UploadPartCopyResponse private constructor(builder: Builder) {
    /**
     * Indicates whether the multipart upload uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).
     */
    val bucketKeyEnabled: kotlin.Boolean = builder.bucketKeyEnabled
    /**
     * Container for all response elements.
     */
    val copyPartResult: aws.sdk.kotlin.services.s3.model.CopyPartResult? = builder.copyPartResult
    /**
     * The version of the source object that was copied, if you have enabled versioning on the source bucket.
     */
    val copySourceVersionId: kotlin.String? = builder.copySourceVersionId
    /**
     * If present, indicates that the requester was successfully charged for the request.
     */
    val requestCharged: aws.sdk.kotlin.services.s3.model.RequestCharged? = builder.requestCharged
    /**
     * The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).
     */
    val serverSideEncryption: aws.sdk.kotlin.services.s3.model.ServerSideEncryption? = builder.serverSideEncryption
    /**
     * If server-side encryption with a customer-provided encryption key was requested, the response will include this header confirming the encryption algorithm used.
     */
    val sseCustomerAlgorithm: kotlin.String? = builder.sseCustomerAlgorithm
    /**
     * If server-side encryption with a customer-provided encryption key was requested, the response will include this header to provide round-trip message integrity verification of the customer-provided encryption key.
     */
    val sseCustomerKeyMd5: kotlin.String? = builder.sseCustomerKeyMd5
    /**
     * If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric customer managed key that was used for the object.
     */
    val ssekmsKeyId: kotlin.String? = builder.ssekmsKeyId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.UploadPartCopyResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UploadPartCopyResponse(")
        append("bucketKeyEnabled=$bucketKeyEnabled,")
        append("copyPartResult=$copyPartResult,")
        append("copySourceVersionId=$copySourceVersionId,")
        append("requestCharged=$requestCharged,")
        append("serverSideEncryption=$serverSideEncryption,")
        append("sseCustomerAlgorithm=$sseCustomerAlgorithm,")
        append("sseCustomerKeyMd5=$sseCustomerKeyMd5,")
        append("ssekmsKeyId=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketKeyEnabled.hashCode()
        result = 31 * result + (copyPartResult?.hashCode() ?: 0)
        result = 31 * result + (copySourceVersionId?.hashCode() ?: 0)
        result = 31 * result + (requestCharged?.hashCode() ?: 0)
        result = 31 * result + (serverSideEncryption?.hashCode() ?: 0)
        result = 31 * result + (sseCustomerAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (sseCustomerKeyMd5?.hashCode() ?: 0)
        result = 31 * result + (ssekmsKeyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UploadPartCopyResponse

        if (bucketKeyEnabled != other.bucketKeyEnabled) return false
        if (copyPartResult != other.copyPartResult) return false
        if (copySourceVersionId != other.copySourceVersionId) return false
        if (requestCharged != other.requestCharged) return false
        if (serverSideEncryption != other.serverSideEncryption) return false
        if (sseCustomerAlgorithm != other.sseCustomerAlgorithm) return false
        if (sseCustomerKeyMd5 != other.sseCustomerKeyMd5) return false
        if (ssekmsKeyId != other.ssekmsKeyId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.UploadPartCopyResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether the multipart upload uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).
         */
        var bucketKeyEnabled: kotlin.Boolean = false
        /**
         * Container for all response elements.
         */
        var copyPartResult: aws.sdk.kotlin.services.s3.model.CopyPartResult? = null
        /**
         * The version of the source object that was copied, if you have enabled versioning on the source bucket.
         */
        var copySourceVersionId: kotlin.String? = null
        /**
         * If present, indicates that the requester was successfully charged for the request.
         */
        var requestCharged: aws.sdk.kotlin.services.s3.model.RequestCharged? = null
        /**
         * The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).
         */
        var serverSideEncryption: aws.sdk.kotlin.services.s3.model.ServerSideEncryption? = null
        /**
         * If server-side encryption with a customer-provided encryption key was requested, the response will include this header confirming the encryption algorithm used.
         */
        var sseCustomerAlgorithm: kotlin.String? = null
        /**
         * If server-side encryption with a customer-provided encryption key was requested, the response will include this header to provide round-trip message integrity verification of the customer-provided encryption key.
         */
        var sseCustomerKeyMd5: kotlin.String? = null
        /**
         * If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric customer managed key that was used for the object.
         */
        var ssekmsKeyId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.UploadPartCopyResponse) : this() {
            this.bucketKeyEnabled = x.bucketKeyEnabled
            this.copyPartResult = x.copyPartResult
            this.copySourceVersionId = x.copySourceVersionId
            this.requestCharged = x.requestCharged
            this.serverSideEncryption = x.serverSideEncryption
            this.sseCustomerAlgorithm = x.sseCustomerAlgorithm
            this.sseCustomerKeyMd5 = x.sseCustomerKeyMd5
            this.ssekmsKeyId = x.ssekmsKeyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.UploadPartCopyResponse = UploadPartCopyResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.CopyPartResult] inside the given [block]
         */
        fun copyPartResult(block: aws.sdk.kotlin.services.s3.model.CopyPartResult.Builder.() -> kotlin.Unit) {
            this.copyPartResult = aws.sdk.kotlin.services.s3.model.CopyPartResult.invoke(block)
        }
    }
}
