// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * Specifies website configuration parameters for an Amazon S3 bucket.
 */
class WebsiteConfiguration private constructor(builder: Builder) {
    /**
     * The name of the error document for the website.
     */
    val errorDocument: aws.sdk.kotlin.services.s3.model.ErrorDocument? = builder.errorDocument
    /**
     * The name of the index document for the website.
     */
    val indexDocument: aws.sdk.kotlin.services.s3.model.IndexDocument? = builder.indexDocument
    /**
     * The redirect behavior for every request to this bucket's website endpoint.
     *
     * If you specify this property, you can't specify any other property.
     */
    val redirectAllRequestsTo: aws.sdk.kotlin.services.s3.model.RedirectAllRequestsTo? = builder.redirectAllRequestsTo
    /**
     * Rules that define when a redirect is applied and the redirect behavior.
     */
    val routingRules: List<RoutingRule>? = builder.routingRules

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.WebsiteConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WebsiteConfiguration(")
        append("errorDocument=$errorDocument,")
        append("indexDocument=$indexDocument,")
        append("redirectAllRequestsTo=$redirectAllRequestsTo,")
        append("routingRules=$routingRules)")
    }

    override fun hashCode(): kotlin.Int {
        var result = errorDocument?.hashCode() ?: 0
        result = 31 * result + (indexDocument?.hashCode() ?: 0)
        result = 31 * result + (redirectAllRequestsTo?.hashCode() ?: 0)
        result = 31 * result + (routingRules?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WebsiteConfiguration

        if (errorDocument != other.errorDocument) return false
        if (indexDocument != other.indexDocument) return false
        if (redirectAllRequestsTo != other.redirectAllRequestsTo) return false
        if (routingRules != other.routingRules) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.WebsiteConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the error document for the website.
         */
        var errorDocument: aws.sdk.kotlin.services.s3.model.ErrorDocument? = null
        /**
         * The name of the index document for the website.
         */
        var indexDocument: aws.sdk.kotlin.services.s3.model.IndexDocument? = null
        /**
         * The redirect behavior for every request to this bucket's website endpoint.
         *
         * If you specify this property, you can't specify any other property.
         */
        var redirectAllRequestsTo: aws.sdk.kotlin.services.s3.model.RedirectAllRequestsTo? = null
        /**
         * Rules that define when a redirect is applied and the redirect behavior.
         */
        var routingRules: List<RoutingRule>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.WebsiteConfiguration) : this() {
            this.errorDocument = x.errorDocument
            this.indexDocument = x.indexDocument
            this.redirectAllRequestsTo = x.redirectAllRequestsTo
            this.routingRules = x.routingRules
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.WebsiteConfiguration = WebsiteConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.ErrorDocument] inside the given [block]
         */
        fun errorDocument(block: aws.sdk.kotlin.services.s3.model.ErrorDocument.Builder.() -> kotlin.Unit) {
            this.errorDocument = aws.sdk.kotlin.services.s3.model.ErrorDocument.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.IndexDocument] inside the given [block]
         */
        fun indexDocument(block: aws.sdk.kotlin.services.s3.model.IndexDocument.Builder.() -> kotlin.Unit) {
            this.indexDocument = aws.sdk.kotlin.services.s3.model.IndexDocument.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.RedirectAllRequestsTo] inside the given [block]
         */
        fun redirectAllRequestsTo(block: aws.sdk.kotlin.services.s3.model.RedirectAllRequestsTo.Builder.() -> kotlin.Unit) {
            this.redirectAllRequestsTo = aws.sdk.kotlin.services.s3.model.RedirectAllRequestsTo.invoke(block)
        }
    }
}
