// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.paginators

import aws.sdk.kotlin.services.s3.S3Client
import aws.sdk.kotlin.services.s3.model.ListObjectsV2Request
import aws.sdk.kotlin.services.s3.model.ListObjectsV2Response
import aws.sdk.kotlin.services.s3.model.ListPartsRequest
import aws.sdk.kotlin.services.s3.model.ListPartsResponse
import aws.sdk.kotlin.services.s3.model.Part
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListObjectsV2Response] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListObjectsV2Request] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListObjectsV2Response]
 */
fun S3Client.listObjectsV2Paginated(initialRequest: ListObjectsV2Request): Flow<ListObjectsV2Response> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.continuationToken = cursor
            }
            val result = this@listObjectsV2Paginated.listObjectsV2(req)
            isFirstPage = false
            cursor = result.nextContinuationToken
            emit(result)
        }
    }

/**
 * Paginate over [ListObjectsV2Response] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListObjectsV2Response]
 */
fun S3Client.listObjectsV2Paginated(block: ListObjectsV2Request.Builder.() -> Unit): Flow<ListObjectsV2Response> =
    listObjectsV2Paginated(ListObjectsV2Request.Builder().apply(block).build())

/**
 * Paginate over [ListPartsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPartsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPartsResponse]
 */
fun S3Client.listPartsPaginated(initialRequest: ListPartsRequest): Flow<ListPartsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.partNumberMarker = cursor
            }
            val result = this@listPartsPaginated.listParts(req)
            isFirstPage = false
            cursor = result.nextPartNumberMarker
            emit(result)
        }
    }

/**
 * Paginate over [ListPartsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPartsResponse]
 */
fun S3Client.listPartsPaginated(block: ListPartsRequest.Builder.() -> Unit): Flow<ListPartsResponse> =
    listPartsPaginated(ListPartsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPartsPaginated]
 * to access the nested member [Part]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Part]
 */
@JvmName("listPartsResponsePart")
fun Flow<ListPartsResponse>.parts(): Flow<Part> =
    transform() { response ->
        response.parts?.forEach {
            emit(it)
        }
    }
