// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.transform

import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.services.s3.internal.S3ErrorDetails
import aws.sdk.kotlin.services.s3.internal.parseS3ErrorResponse
import aws.sdk.kotlin.services.s3.internal.setS3ErrorMetadata
import aws.sdk.kotlin.services.s3.model.Checksum
import aws.sdk.kotlin.services.s3.model.GetObjectAttributesParts
import aws.sdk.kotlin.services.s3.model.GetObjectAttributesResponse
import aws.sdk.kotlin.services.s3.model.RequestCharged
import aws.sdk.kotlin.services.s3.model.S3Exception
import aws.sdk.kotlin.services.s3.model.StorageClass
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpStatusCode
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant


internal class GetObjectAttributesOperationDeserializer: HttpDeserialize<GetObjectAttributesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetObjectAttributesResponse {
        if (!response.status.isSuccess()) {
            throwGetObjectAttributesError(context, response)
        }
        val builder = GetObjectAttributesResponse.Builder()

        builder.deleteMarker = response.headers["x-amz-delete-marker"]?.toBoolean() ?: false
        builder.lastModified = response.headers["Last-Modified"]?.let { Instant.fromRfc5322(it) }
        builder.requestCharged = response.headers["x-amz-request-charged"]?.let { RequestCharged.fromValue(it) }
        builder.versionId = response.headers["x-amz-version-id"]

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetObjectAttributesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetObjectAttributesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        if (payload == null && response.status == HttpStatusCode.NotFound) {
            S3ErrorDetails(code = "NotFound")
        } else {
            checkNotNull(payload){ "unable to parse error from empty response" }
            parseS3ErrorResponse(payload)
        }
    } catch (ex: Exception) {
        throw S3Exception("Failed to parse response as 'restXml' error", ex).also {
            setS3ErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NoSuchKey" -> NoSuchKeyDeserializer().deserialize(context, wrappedResponse)
        else -> S3Exception(errorDetails.message)
    }

    setS3ErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetObjectAttributesOperationBody(builder: GetObjectAttributesResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val CHECKSUM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Checksum"))
    val ETAG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ETag"))
    val OBJECTPARTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ObjectParts"))
    val OBJECTSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, XmlSerialName("ObjectSize"))
    val STORAGECLASS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("StorageClass"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("GetObjectAttributesOutput"))
        trait(XmlNamespace("http://s3.amazonaws.com/doc/2006-03-01/"))
        field(CHECKSUM_DESCRIPTOR)
        field(ETAG_DESCRIPTOR)
        field(OBJECTPARTS_DESCRIPTOR)
        field(OBJECTSIZE_DESCRIPTOR)
        field(STORAGECLASS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHECKSUM_DESCRIPTOR.index -> builder.checksum = deserializeChecksumDocument(deserializer)
                ETAG_DESCRIPTOR.index -> builder.eTag = deserializeString()
                OBJECTPARTS_DESCRIPTOR.index -> builder.objectParts = deserializeGetObjectAttributesPartsDocument(deserializer)
                OBJECTSIZE_DESCRIPTOR.index -> builder.objectSize = deserializeLong()
                STORAGECLASS_DESCRIPTOR.index -> builder.storageClass = deserializeString().let { StorageClass.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
