// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * Specifies encryption-related information for an Amazon S3 bucket that is a destination for replicated objects.
 */
public class EncryptionConfiguration private constructor(builder: Builder) {
    /**
     * Specifies the ID (Key ARN or Alias ARN) of the customer managed Amazon Web Services KMS key stored in Amazon Web Services Key Management Service (KMS) for the destination bucket. Amazon S3 uses this key to encrypt replica objects. Amazon S3 only supports symmetric, customer managed KMS keys. For more information, see [Using symmetric and asymmetric keys](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html) in the *Amazon Web Services Key Management Service Developer Guide*.
     */
    public val replicaKmsKeyId: kotlin.String? = builder.replicaKmsKeyId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.EncryptionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EncryptionConfiguration(")
        append("replicaKmsKeyId=$replicaKmsKeyId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = replicaKmsKeyId?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EncryptionConfiguration

        if (replicaKmsKeyId != other.replicaKmsKeyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.EncryptionConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the ID (Key ARN or Alias ARN) of the customer managed Amazon Web Services KMS key stored in Amazon Web Services Key Management Service (KMS) for the destination bucket. Amazon S3 uses this key to encrypt replica objects. Amazon S3 only supports symmetric, customer managed KMS keys. For more information, see [Using symmetric and asymmetric keys](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html) in the *Amazon Web Services Key Management Service Developer Guide*.
         */
        public var replicaKmsKeyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.EncryptionConfiguration) : this() {
            this.replicaKmsKeyId = x.replicaKmsKeyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.EncryptionConfiguration = EncryptionConfiguration(this)
    }
}
