// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * Specifies the S3 Intelligent-Tiering configuration for an Amazon S3 bucket.
 *
 * For information about the S3 Intelligent-Tiering storage class, see [Storage class for automatically optimizing frequently and infrequently accessed objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access).
 */
public class IntelligentTieringConfiguration private constructor(builder: Builder) {
    /**
     * Specifies a bucket filter. The configuration only includes objects that meet the filter's criteria.
     */
    public val filter: aws.sdk.kotlin.services.s3.model.IntelligentTieringFilter? = builder.filter
    /**
     * The ID used to identify the S3 Intelligent-Tiering configuration.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Specifies the status of the configuration.
     */
    public val status: aws.sdk.kotlin.services.s3.model.IntelligentTieringStatus? = builder.status
    /**
     * Specifies the S3 Intelligent-Tiering storage class tier of the configuration.
     */
    public val tierings: List<Tiering>? = builder.tierings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.IntelligentTieringConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IntelligentTieringConfiguration(")
        append("filter=$filter,")
        append("id=$id,")
        append("status=$status,")
        append("tierings=$tierings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filter?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tierings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IntelligentTieringConfiguration

        if (filter != other.filter) return false
        if (id != other.id) return false
        if (status != other.status) return false
        if (tierings != other.tierings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.IntelligentTieringConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies a bucket filter. The configuration only includes objects that meet the filter's criteria.
         */
        public var filter: aws.sdk.kotlin.services.s3.model.IntelligentTieringFilter? = null
        /**
         * The ID used to identify the S3 Intelligent-Tiering configuration.
         */
        public var id: kotlin.String? = null
        /**
         * Specifies the status of the configuration.
         */
        public var status: aws.sdk.kotlin.services.s3.model.IntelligentTieringStatus? = null
        /**
         * Specifies the S3 Intelligent-Tiering storage class tier of the configuration.
         */
        public var tierings: List<Tiering>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.IntelligentTieringConfiguration) : this() {
            this.filter = x.filter
            this.id = x.id
            this.status = x.status
            this.tierings = x.tierings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.IntelligentTieringConfiguration = IntelligentTieringConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.IntelligentTieringFilter] inside the given [block]
         */
        public fun filter(block: aws.sdk.kotlin.services.s3.model.IntelligentTieringFilter.Builder.() -> kotlin.Unit) {
            this.filter = aws.sdk.kotlin.services.s3.model.IntelligentTieringFilter.invoke(block)
        }
    }
}
