// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * The `Filter` is used to identify objects that the S3 Intelligent-Tiering configuration applies to.
 */
public class IntelligentTieringFilter private constructor(builder: Builder) {
    /**
     * A conjunction (logical AND) of predicates, which is used in evaluating a metrics filter. The operator must have at least two predicates, and an object must match all of the predicates in order for the filter to apply.
     */
    public val and: aws.sdk.kotlin.services.s3.model.IntelligentTieringAndOperator? = builder.and
    /**
     * An object key name prefix that identifies the subset of objects to which the rule applies.
     *
     * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [ XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
     */
    public val prefix: kotlin.String? = builder.prefix
    /**
     * A container of a key value name pair.
     */
    public val tag: aws.sdk.kotlin.services.s3.model.Tag? = builder.tag

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.IntelligentTieringFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IntelligentTieringFilter(")
        append("and=$and,")
        append("prefix=$prefix,")
        append("tag=$tag)")
    }

    override fun hashCode(): kotlin.Int {
        var result = and?.hashCode() ?: 0
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (tag?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IntelligentTieringFilter

        if (and != other.and) return false
        if (prefix != other.prefix) return false
        if (tag != other.tag) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.IntelligentTieringFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A conjunction (logical AND) of predicates, which is used in evaluating a metrics filter. The operator must have at least two predicates, and an object must match all of the predicates in order for the filter to apply.
         */
        public var and: aws.sdk.kotlin.services.s3.model.IntelligentTieringAndOperator? = null
        /**
         * An object key name prefix that identifies the subset of objects to which the rule applies.
         *
         * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [ XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
         */
        public var prefix: kotlin.String? = null
        /**
         * A container of a key value name pair.
         */
        public var tag: aws.sdk.kotlin.services.s3.model.Tag? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.IntelligentTieringFilter) : this() {
            this.and = x.and
            this.prefix = x.prefix
            this.tag = x.tag
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.IntelligentTieringFilter = IntelligentTieringFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.IntelligentTieringAndOperator] inside the given [block]
         */
        public fun and(block: aws.sdk.kotlin.services.s3.model.IntelligentTieringAndOperator.Builder.() -> kotlin.Unit) {
            this.and = aws.sdk.kotlin.services.s3.model.IntelligentTieringAndOperator.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.Tag] inside the given [block]
         */
        public fun tag(block: aws.sdk.kotlin.services.s3.model.Tag.Builder.() -> kotlin.Unit) {
            this.tag = aws.sdk.kotlin.services.s3.model.Tag.invoke(block)
        }
    }
}
