// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * The `Filter` is used to identify objects that a Lifecycle Rule applies to. A `Filter` must have exactly one of `Prefix`, `Tag`, or `And` specified.
 */
public sealed class LifecycleRuleFilter {
    /**
     * This is used in a Lifecycle Rule Filter to apply a logical AND to two or more predicates. The Lifecycle Rule will apply to any object matching all of the predicates configured inside the And operator.
     */
    public data class And(val value: aws.sdk.kotlin.services.s3.model.LifecycleRuleAndOperator) : aws.sdk.kotlin.services.s3.model.LifecycleRuleFilter()
    /**
     * Minimum object size to which the rule applies.
     */
    public data class ObjectSizeGreaterThan(val value: kotlin.Long) : aws.sdk.kotlin.services.s3.model.LifecycleRuleFilter()
    /**
     * Maximum object size to which the rule applies.
     */
    public data class ObjectSizeLessThan(val value: kotlin.Long) : aws.sdk.kotlin.services.s3.model.LifecycleRuleFilter()
    /**
     * Prefix identifying one or more objects to which the rule applies.
     *
     * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [ XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
     */
    public data class Prefix(val value: kotlin.String) : aws.sdk.kotlin.services.s3.model.LifecycleRuleFilter()
    /**
     * This tag must exist in the object's tag set in order for the rule to apply.
     */
    public data class Tag(val value: aws.sdk.kotlin.services.s3.model.Tag) : aws.sdk.kotlin.services.s3.model.LifecycleRuleFilter()
    public object SdkUnknown : aws.sdk.kotlin.services.s3.model.LifecycleRuleFilter()

    /**
     * Casts this [LifecycleRuleFilter] as a [And] and retrieves its [aws.sdk.kotlin.services.s3.model.LifecycleRuleAndOperator] value. Throws an exception if the [LifecycleRuleFilter] is not a
     * [And].
     */
    public fun asAnd(): aws.sdk.kotlin.services.s3.model.LifecycleRuleAndOperator = (this as LifecycleRuleFilter.And).value

    /**
     * Casts this [LifecycleRuleFilter] as a [And] and retrieves its [aws.sdk.kotlin.services.s3.model.LifecycleRuleAndOperator] value. Returns null if the [LifecycleRuleFilter] is not a [And].
     */
    public fun asAndOrNull(): aws.sdk.kotlin.services.s3.model.LifecycleRuleAndOperator? = (this as? LifecycleRuleFilter.And)?.value

    /**
     * Casts this [LifecycleRuleFilter] as a [ObjectSizeGreaterThan] and retrieves its [kotlin.Long] value. Throws an exception if the [LifecycleRuleFilter] is not a
     * [ObjectSizeGreaterThan].
     */
    public fun asObjectSizeGreaterThan(): kotlin.Long = (this as LifecycleRuleFilter.ObjectSizeGreaterThan).value

    /**
     * Casts this [LifecycleRuleFilter] as a [ObjectSizeGreaterThan] and retrieves its [kotlin.Long] value. Returns null if the [LifecycleRuleFilter] is not a [ObjectSizeGreaterThan].
     */
    public fun asObjectSizeGreaterThanOrNull(): kotlin.Long? = (this as? LifecycleRuleFilter.ObjectSizeGreaterThan)?.value

    /**
     * Casts this [LifecycleRuleFilter] as a [ObjectSizeLessThan] and retrieves its [kotlin.Long] value. Throws an exception if the [LifecycleRuleFilter] is not a
     * [ObjectSizeLessThan].
     */
    public fun asObjectSizeLessThan(): kotlin.Long = (this as LifecycleRuleFilter.ObjectSizeLessThan).value

    /**
     * Casts this [LifecycleRuleFilter] as a [ObjectSizeLessThan] and retrieves its [kotlin.Long] value. Returns null if the [LifecycleRuleFilter] is not a [ObjectSizeLessThan].
     */
    public fun asObjectSizeLessThanOrNull(): kotlin.Long? = (this as? LifecycleRuleFilter.ObjectSizeLessThan)?.value

    /**
     * Casts this [LifecycleRuleFilter] as a [Prefix] and retrieves its [kotlin.String] value. Throws an exception if the [LifecycleRuleFilter] is not a
     * [Prefix].
     */
    public fun asPrefix(): kotlin.String = (this as LifecycleRuleFilter.Prefix).value

    /**
     * Casts this [LifecycleRuleFilter] as a [Prefix] and retrieves its [kotlin.String] value. Returns null if the [LifecycleRuleFilter] is not a [Prefix].
     */
    public fun asPrefixOrNull(): kotlin.String? = (this as? LifecycleRuleFilter.Prefix)?.value

    /**
     * Casts this [LifecycleRuleFilter] as a [Tag] and retrieves its [aws.sdk.kotlin.services.s3.model.Tag] value. Throws an exception if the [LifecycleRuleFilter] is not a
     * [Tag].
     */
    public fun asTag(): aws.sdk.kotlin.services.s3.model.Tag = (this as LifecycleRuleFilter.Tag).value

    /**
     * Casts this [LifecycleRuleFilter] as a [Tag] and retrieves its [aws.sdk.kotlin.services.s3.model.Tag] value. Returns null if the [LifecycleRuleFilter] is not a [Tag].
     */
    public fun asTagOrNull(): aws.sdk.kotlin.services.s3.model.Tag? = (this as? LifecycleRuleFilter.Tag)?.value
}
