// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * Object Identifier is unique value to identify objects.
 */
public class ObjectIdentifier private constructor(builder: Builder) {
    /**
     * Key name of the object.
     *
     * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [ XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
     */
    public val key: kotlin.String? = builder.key
    /**
     * VersionId for the specific version of the object to delete.
     */
    public val versionId: kotlin.String? = builder.versionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.ObjectIdentifier = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ObjectIdentifier(")
        append("key=$key,")
        append("versionId=$versionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = key?.hashCode() ?: 0
        result = 31 * result + (versionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ObjectIdentifier

        if (key != other.key) return false
        if (versionId != other.versionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.ObjectIdentifier = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Key name of the object.
         *
         * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [ XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
         */
        public var key: kotlin.String? = null
        /**
         * VersionId for the specific version of the object to delete.
         */
        public var versionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.ObjectIdentifier) : this() {
            this.key = x.key
            this.versionId = x.versionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.ObjectIdentifier = ObjectIdentifier(this)
    }
}
