// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



public class PutBucketAclRequest private constructor(builder: Builder) {
    /**
     * Contains the elements that set the ACL permissions for an object per grantee.
     */
    public val accessControlPolicy: aws.sdk.kotlin.services.s3.model.AccessControlPolicy? = builder.accessControlPolicy
    /**
     * The canned ACL to apply to the bucket.
     */
    public val acl: aws.sdk.kotlin.services.s3.model.BucketCannedAcl? = builder.acl
    /**
     * The bucket to which to apply the ACL.
     */
    public val bucket: kotlin.String? = requireNotNull(builder.bucket) { "A non-null value must be provided for bucket" }
    /**
     * The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to [RFC 1864.](http://www.ietf.org/rfc/rfc1864.txt)
     *
     * For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.
     */
    public val contentMd5: kotlin.String? = builder.contentMd5
    /**
     * The account ID of the expected bucket owner. If the bucket is owned by a different account, the request fails with the HTTP status code `403 Forbidden` (access denied).
     */
    public val expectedBucketOwner: kotlin.String? = builder.expectedBucketOwner
    /**
     * Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.
     */
    public val grantFullControl: kotlin.String? = builder.grantFullControl
    /**
     * Allows grantee to list the objects in the bucket.
     */
    public val grantRead: kotlin.String? = builder.grantRead
    /**
     * Allows grantee to read the bucket ACL.
     */
    public val grantReadAcp: kotlin.String? = builder.grantReadAcp
    /**
     * Allows grantee to create new objects in the bucket.
     *
     * For the bucket and object owners of existing objects, also allows deletions and overwrites of those objects.
     */
    public val grantWrite: kotlin.String? = builder.grantWrite
    /**
     * Allows grantee to write the ACL for the applicable bucket.
     */
    public val grantWriteAcp: kotlin.String? = builder.grantWriteAcp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.PutBucketAclRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutBucketAclRequest(")
        append("accessControlPolicy=$accessControlPolicy,")
        append("acl=$acl,")
        append("bucket=$bucket,")
        append("contentMd5=$contentMd5,")
        append("expectedBucketOwner=$expectedBucketOwner,")
        append("grantFullControl=$grantFullControl,")
        append("grantRead=$grantRead,")
        append("grantReadAcp=$grantReadAcp,")
        append("grantWrite=$grantWrite,")
        append("grantWriteAcp=$grantWriteAcp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessControlPolicy?.hashCode() ?: 0
        result = 31 * result + (acl?.hashCode() ?: 0)
        result = 31 * result + (bucket?.hashCode() ?: 0)
        result = 31 * result + (contentMd5?.hashCode() ?: 0)
        result = 31 * result + (expectedBucketOwner?.hashCode() ?: 0)
        result = 31 * result + (grantFullControl?.hashCode() ?: 0)
        result = 31 * result + (grantRead?.hashCode() ?: 0)
        result = 31 * result + (grantReadAcp?.hashCode() ?: 0)
        result = 31 * result + (grantWrite?.hashCode() ?: 0)
        result = 31 * result + (grantWriteAcp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutBucketAclRequest

        if (accessControlPolicy != other.accessControlPolicy) return false
        if (acl != other.acl) return false
        if (bucket != other.bucket) return false
        if (contentMd5 != other.contentMd5) return false
        if (expectedBucketOwner != other.expectedBucketOwner) return false
        if (grantFullControl != other.grantFullControl) return false
        if (grantRead != other.grantRead) return false
        if (grantReadAcp != other.grantReadAcp) return false
        if (grantWrite != other.grantWrite) return false
        if (grantWriteAcp != other.grantWriteAcp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.PutBucketAclRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Contains the elements that set the ACL permissions for an object per grantee.
         */
        public var accessControlPolicy: aws.sdk.kotlin.services.s3.model.AccessControlPolicy? = null
        /**
         * The canned ACL to apply to the bucket.
         */
        public var acl: aws.sdk.kotlin.services.s3.model.BucketCannedAcl? = null
        /**
         * The bucket to which to apply the ACL.
         */
        public var bucket: kotlin.String? = null
        /**
         * The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to [RFC 1864.](http://www.ietf.org/rfc/rfc1864.txt)
         *
         * For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.
         */
        public var contentMd5: kotlin.String? = null
        /**
         * The account ID of the expected bucket owner. If the bucket is owned by a different account, the request fails with the HTTP status code `403 Forbidden` (access denied).
         */
        public var expectedBucketOwner: kotlin.String? = null
        /**
         * Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.
         */
        public var grantFullControl: kotlin.String? = null
        /**
         * Allows grantee to list the objects in the bucket.
         */
        public var grantRead: kotlin.String? = null
        /**
         * Allows grantee to read the bucket ACL.
         */
        public var grantReadAcp: kotlin.String? = null
        /**
         * Allows grantee to create new objects in the bucket.
         *
         * For the bucket and object owners of existing objects, also allows deletions and overwrites of those objects.
         */
        public var grantWrite: kotlin.String? = null
        /**
         * Allows grantee to write the ACL for the applicable bucket.
         */
        public var grantWriteAcp: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.PutBucketAclRequest) : this() {
            this.accessControlPolicy = x.accessControlPolicy
            this.acl = x.acl
            this.bucket = x.bucket
            this.contentMd5 = x.contentMd5
            this.expectedBucketOwner = x.expectedBucketOwner
            this.grantFullControl = x.grantFullControl
            this.grantRead = x.grantRead
            this.grantReadAcp = x.grantReadAcp
            this.grantWrite = x.grantWrite
            this.grantWriteAcp = x.grantWriteAcp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.PutBucketAclRequest = PutBucketAclRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.AccessControlPolicy] inside the given [block]
         */
        public fun accessControlPolicy(block: aws.sdk.kotlin.services.s3.model.AccessControlPolicy.Builder.() -> kotlin.Unit) {
            this.accessControlPolicy = aws.sdk.kotlin.services.s3.model.AccessControlPolicy.invoke(block)
        }
    }
}
