// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



public class PutObjectRetentionRequest private constructor(builder: Builder) {
    /**
     * The bucket name that contains the object you want to apply this Object Retention configuration to.
     *
     * When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see [Using access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html) in the *Amazon S3 User Guide*.
     */
    public val bucket: kotlin.String? = requireNotNull(builder.bucket) { "A non-null value must be provided for bucket" }
    /**
     * Indicates whether this action should bypass Governance-mode restrictions.
     */
    public val bypassGovernanceRetention: kotlin.Boolean = builder.bypassGovernanceRetention
    /**
     * The MD5 hash for the request body.
     *
     * For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.
     */
    public val contentMd5: kotlin.String? = builder.contentMd5
    /**
     * The account ID of the expected bucket owner. If the bucket is owned by a different account, the request fails with the HTTP status code `403 Forbidden` (access denied).
     */
    public val expectedBucketOwner: kotlin.String? = builder.expectedBucketOwner
    /**
     * The key name for the object that you want to apply this Object Retention configuration to.
     */
    public val key: kotlin.String? = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from Requester Pays buckets, see [Downloading Objects in Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html) in the *Amazon S3 User Guide*.
     */
    public val requestPayer: aws.sdk.kotlin.services.s3.model.RequestPayer? = builder.requestPayer
    /**
     * The container element for the Object Retention configuration.
     */
    public val retention: aws.sdk.kotlin.services.s3.model.ObjectLockRetention? = builder.retention
    /**
     * The version ID for the object that you want to apply this Object Retention configuration to.
     */
    public val versionId: kotlin.String? = builder.versionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.PutObjectRetentionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutObjectRetentionRequest(")
        append("bucket=$bucket,")
        append("bypassGovernanceRetention=$bypassGovernanceRetention,")
        append("contentMd5=$contentMd5,")
        append("expectedBucketOwner=$expectedBucketOwner,")
        append("key=$key,")
        append("requestPayer=$requestPayer,")
        append("retention=$retention,")
        append("versionId=$versionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (bypassGovernanceRetention.hashCode())
        result = 31 * result + (contentMd5?.hashCode() ?: 0)
        result = 31 * result + (expectedBucketOwner?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (requestPayer?.hashCode() ?: 0)
        result = 31 * result + (retention?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutObjectRetentionRequest

        if (bucket != other.bucket) return false
        if (bypassGovernanceRetention != other.bypassGovernanceRetention) return false
        if (contentMd5 != other.contentMd5) return false
        if (expectedBucketOwner != other.expectedBucketOwner) return false
        if (key != other.key) return false
        if (requestPayer != other.requestPayer) return false
        if (retention != other.retention) return false
        if (versionId != other.versionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.PutObjectRetentionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The bucket name that contains the object you want to apply this Object Retention configuration to.
         *
         * When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see [Using access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html) in the *Amazon S3 User Guide*.
         */
        public var bucket: kotlin.String? = null
        /**
         * Indicates whether this action should bypass Governance-mode restrictions.
         */
        public var bypassGovernanceRetention: kotlin.Boolean = false
        /**
         * The MD5 hash for the request body.
         *
         * For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.
         */
        public var contentMd5: kotlin.String? = null
        /**
         * The account ID of the expected bucket owner. If the bucket is owned by a different account, the request fails with the HTTP status code `403 Forbidden` (access denied).
         */
        public var expectedBucketOwner: kotlin.String? = null
        /**
         * The key name for the object that you want to apply this Object Retention configuration to.
         */
        public var key: kotlin.String? = null
        /**
         * Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from Requester Pays buckets, see [Downloading Objects in Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html) in the *Amazon S3 User Guide*.
         */
        public var requestPayer: aws.sdk.kotlin.services.s3.model.RequestPayer? = null
        /**
         * The container element for the Object Retention configuration.
         */
        public var retention: aws.sdk.kotlin.services.s3.model.ObjectLockRetention? = null
        /**
         * The version ID for the object that you want to apply this Object Retention configuration to.
         */
        public var versionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.PutObjectRetentionRequest) : this() {
            this.bucket = x.bucket
            this.bypassGovernanceRetention = x.bypassGovernanceRetention
            this.contentMd5 = x.contentMd5
            this.expectedBucketOwner = x.expectedBucketOwner
            this.key = x.key
            this.requestPayer = x.requestPayer
            this.retention = x.retention
            this.versionId = x.versionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.PutObjectRetentionRequest = PutObjectRetentionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.ObjectLockRetention] inside the given [block]
         */
        public fun retention(block: aws.sdk.kotlin.services.s3.model.ObjectLockRetention.Builder.() -> kotlin.Unit) {
            this.retention = aws.sdk.kotlin.services.s3.model.ObjectLockRetention.invoke(block)
        }
    }
}
