// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * Specifies the redirect behavior and when a redirect is applied. For more information about routing rules, see [Configuring advanced conditional redirects](https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html#advanced-conditional-redirects) in the *Amazon S3 User Guide*.
 */
public class RoutingRule private constructor(builder: Builder) {
    /**
     * A container for describing a condition that must be met for the specified redirect to apply. For example, 1. If request is for pages in the `/docs` folder, redirect to the `/documents` folder. 2. If request results in HTTP error 4xx, redirect request to another host where you might process the error.
     */
    public val condition: aws.sdk.kotlin.services.s3.model.Condition? = builder.condition
    /**
     * Container for redirect information. You can redirect requests to another host, to another page, or with another protocol. In the event of an error, you can specify a different error code to return.
     */
    public val redirect: aws.sdk.kotlin.services.s3.model.Redirect? = builder.redirect

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.RoutingRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RoutingRule(")
        append("condition=$condition,")
        append("redirect=$redirect)")
    }

    override fun hashCode(): kotlin.Int {
        var result = condition?.hashCode() ?: 0
        result = 31 * result + (redirect?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RoutingRule

        if (condition != other.condition) return false
        if (redirect != other.redirect) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.RoutingRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A container for describing a condition that must be met for the specified redirect to apply. For example, 1. If request is for pages in the `/docs` folder, redirect to the `/documents` folder. 2. If request results in HTTP error 4xx, redirect request to another host where you might process the error.
         */
        public var condition: aws.sdk.kotlin.services.s3.model.Condition? = null
        /**
         * Container for redirect information. You can redirect requests to another host, to another page, or with another protocol. In the event of an error, you can specify a different error code to return.
         */
        public var redirect: aws.sdk.kotlin.services.s3.model.Redirect? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.RoutingRule) : this() {
            this.condition = x.condition
            this.redirect = x.redirect
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.RoutingRule = RoutingRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.Condition] inside the given [block]
         */
        public fun condition(block: aws.sdk.kotlin.services.s3.model.Condition.Builder.() -> kotlin.Unit) {
            this.condition = aws.sdk.kotlin.services.s3.model.Condition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.Redirect] inside the given [block]
         */
        public fun redirect(block: aws.sdk.kotlin.services.s3.model.Redirect.Builder.() -> kotlin.Unit) {
            this.redirect = aws.sdk.kotlin.services.s3.model.Redirect.invoke(block)
        }
    }
}
