/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.services.s3.internal;

import aws.sdk.kotlin.runtime.AwsServiceException;
import aws.sdk.kotlin.runtime.http.AwsErrorDetails;
import aws.sdk.kotlin.runtime.http.ProtocolErrorsKt;
import aws.sdk.kotlin.services.s3.internal.S3ErrorDetails;
import aws.sdk.kotlin.services.s3.model.S3ErrorMetadata;
import aws.sdk.kotlin.services.s3.model.S3Exception;
import aws.smithy.kotlin.runtime.ServiceErrorMetadata;
import aws.smithy.kotlin.runtime.http.response.HttpResponse;
import aws.smithy.kotlin.runtime.serde.Deserializer;
import aws.smithy.kotlin.runtime.serde.FieldTrait;
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor;
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor;
import aws.smithy.kotlin.runtime.serde.SerialKind;
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer;
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName;
import aws.smithy.kotlin.runtime.util.AttributeKey;
import aws.smithy.kotlin.runtime.util.Attributes;
import aws.smithy.kotlin.runtime.util.AttributesKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"X_AMZN_REQUEST_ID_2_HEADER", "", "parseS3ErrorResponse", "Laws/sdk/kotlin/services/s3/internal/S3ErrorDetails;", "payload", "", "setS3ErrorMetadata", "", "exception", "", "response", "Laws/smithy/kotlin/runtime/http/response/HttpResponse;", "errorDetails", "s3"})
public final class S3ErrorMetadataKt {
    @NotNull
    private static final String X_AMZN_REQUEST_ID_2_HEADER = "x-amz-id-2";

    public static final void setS3ErrorMetadata(@NotNull Object exception, @NotNull HttpResponse response, @Nullable S3ErrorDetails errorDetails) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        ProtocolErrorsKt.setAseErrorMetadata((Object)exception, (HttpResponse)response, (AwsErrorDetails)errorDetails);
        if (exception instanceof AwsServiceException) {
            S3ErrorDetails s3ErrorDetails = errorDetails;
            AttributesKt.setIfValueNotNull((Attributes)((AwsServiceException)exception).getSdkErrorMetadata().getAttributes(), (AttributeKey)ServiceErrorMetadata.Companion.getRequestId(), (Object)(s3ErrorDetails == null ? null : s3ErrorDetails.getRequestId()));
        }
        if (exception instanceof S3Exception) {
            S3ErrorDetails s3ErrorDetails = errorDetails;
            String string = s3ErrorDetails == null ? null : s3ErrorDetails.getRequestId2();
            if (string == null) {
                string = response.getHeaders().get(X_AMZN_REQUEST_ID_2_HEADER);
            }
            String requestId2 = string;
            AttributesKt.setIfValueNotNull((Attributes)((S3Exception)((Object)exception)).getSdkErrorMetadata().getAttributes(), S3ErrorMetadata.Companion.getRequestId2(), (Object)requestId2);
        }
    }

    @NotNull
    public static final S3ErrorDetails parseS3ErrorResponse(@NotNull byte[] payload) {
        Deserializer.FieldIterator deserializer$iv;
        SdkObjectDescriptor.Builder builder;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        FieldTrait[] fieldTraitArray = new FieldTrait[]{(FieldTrait)new XmlSerialName("Message")};
        SdkFieldDescriptor MESSAGE_DESCRIPTOR = new SdkFieldDescriptor((SerialKind)SerialKind.String.INSTANCE, fieldTraitArray);
        FieldTrait[] fieldTraitArray2 = new FieldTrait[]{(FieldTrait)new XmlSerialName("Code")};
        SdkFieldDescriptor CODE_DESCRIPTOR = new SdkFieldDescriptor((SerialKind)SerialKind.String.INSTANCE, fieldTraitArray2);
        FieldTrait[] fieldTraitArray3 = new FieldTrait[]{(FieldTrait)new XmlSerialName("RequestId")};
        SdkFieldDescriptor REQUESTID_DESCRIPTOR = new SdkFieldDescriptor((SerialKind)SerialKind.String.INSTANCE, fieldTraitArray3);
        FieldTrait[] fieldTraitArray4 = new FieldTrait[]{(FieldTrait)new XmlSerialName("HostId")};
        SdkFieldDescriptor HOSTID_DESCRIPTOR = new SdkFieldDescriptor((SerialKind)SerialKind.String.INSTANCE, fieldTraitArray4);
        SdkObjectDescriptor.Companion this_$iv = SdkObjectDescriptor.Companion;
        boolean $i$f$build = false;
        SdkObjectDescriptor.Builder $this$parseS3ErrorResponse_u24lambda_u2d0 = builder = new SdkObjectDescriptor.Builder();
        boolean bl = false;
        $this$parseS3ErrorResponse_u24lambda_u2d0.trait((FieldTrait)new XmlSerialName("Error"));
        $this$parseS3ErrorResponse_u24lambda_u2d0.field(MESSAGE_DESCRIPTOR);
        $this$parseS3ErrorResponse_u24lambda_u2d0.field(CODE_DESCRIPTOR);
        $this$parseS3ErrorResponse_u24lambda_u2d0.field(REQUESTID_DESCRIPTOR);
        $this$parseS3ErrorResponse_u24lambda_u2d0.field(HOSTID_DESCRIPTOR);
        SdkObjectDescriptor OBJ_DESCRIPTOR = builder.build();
        String message = null;
        String code = null;
        String requestId = null;
        String requestId2 = null;
        XmlDeserializer deserializer = new XmlDeserializer(payload, true);
        Deserializer $this$deserializeStruct$iv = (Deserializer)deserializer;
        boolean $i$f$deserializeStruct = false;
        Deserializer.FieldIterator $this$parseS3ErrorResponse_u24lambda_u2d1 = deserializer$iv = $this$deserializeStruct$iv.deserializeStruct(OBJ_DESCRIPTOR);
        boolean bl2 = false;
        while (true) {
            Integer n;
            Integer n2 = n = $this$parseS3ErrorResponse_u24lambda_u2d1.findNextFieldIndex();
            int n3 = MESSAGE_DESCRIPTOR.getIndex();
            if (n2 != null && n2 == n3) {
                message = $this$parseS3ErrorResponse_u24lambda_u2d1.deserializeString();
                continue;
            }
            Integer n4 = n;
            n3 = CODE_DESCRIPTOR.getIndex();
            if (n4 != null && n4 == n3) {
                code = $this$parseS3ErrorResponse_u24lambda_u2d1.deserializeString();
                continue;
            }
            Integer n5 = n;
            n3 = REQUESTID_DESCRIPTOR.getIndex();
            if (n5 != null && n5 == n3) {
                requestId = $this$parseS3ErrorResponse_u24lambda_u2d1.deserializeString();
                continue;
            }
            Integer n6 = n;
            n3 = HOSTID_DESCRIPTOR.getIndex();
            if (n6 != null && n6 == n3) {
                requestId2 = $this$parseS3ErrorResponse_u24lambda_u2d1.deserializeString();
                continue;
            }
            if (n == null) break;
            $this$parseS3ErrorResponse_u24lambda_u2d1.skipValue();
        }
        return new S3ErrorDetails(code, message, requestId, requestId2);
    }
}

