/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.services.s3.transform;

import aws.sdk.kotlin.services.s3.model.CreateMultipartUploadRequest;
import aws.sdk.kotlin.services.s3.transform.CreateMultipartUploadOperationSerializer;
import aws.smithy.kotlin.runtime.client.ExecutionContext;
import aws.smithy.kotlin.runtime.http.HeadersBuilder;
import aws.smithy.kotlin.runtime.http.HttpMethod;
import aws.smithy.kotlin.runtime.http.UrlBuilder;
import aws.smithy.kotlin.runtime.http.UrlKt;
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize;
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder;
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilderKt;
import aws.smithy.kotlin.runtime.http.util.TextKt;
import aws.smithy.kotlin.runtime.time.TimestampFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J!\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\t\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\n"}, d2={"Laws/sdk/kotlin/services/s3/transform/CreateMultipartUploadOperationSerializer;", "Laws/smithy/kotlin/runtime/http/operation/HttpSerialize;", "Laws/sdk/kotlin/services/s3/model/CreateMultipartUploadRequest;", "()V", "serialize", "Laws/smithy/kotlin/runtime/http/request/HttpRequestBuilder;", "context", "Laws/smithy/kotlin/runtime/client/ExecutionContext;", "input", "(Laws/smithy/kotlin/runtime/client/ExecutionContext;Laws/sdk/kotlin/services/s3/model/CreateMultipartUploadRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "s3"})
public final class CreateMultipartUploadOperationSerializer
implements HttpSerialize<CreateMultipartUploadRequest> {
    @Nullable
    public Object serialize(@NotNull ExecutionContext context, @NotNull CreateMultipartUploadRequest input, @NotNull Continuation<? super HttpRequestBuilder> $completion) {
        HttpRequestBuilder builder = new HttpRequestBuilder();
        builder.setMethod(HttpMethod.POST);
        HttpRequestBuilderKt.url((HttpRequestBuilder)builder, (Function1)((Function1)new Function1<UrlBuilder, Unit>(input){
            final /* synthetic */ CreateMultipartUploadRequest $input;
            {
                this.$input = $input;
                super(1);
            }

            public final void invoke(@NotNull UrlBuilder $this$url) {
                Intrinsics.checkNotNullParameter((Object)$this$url, (String)"$this$url");
                Object[] objectArray = new String[]{TextKt.encodeLabel$default((String)String.valueOf(this.$input.getBucket()), (boolean)false, (int)1, null), TextKt.encodeLabel((String)String.valueOf(this.$input.getKey()), (boolean)true)};
                List pathSegments = CollectionsKt.listOf((Object[])objectArray);
                $this$url.setPath(CollectionsKt.joinToString$default((Iterable)pathSegments, (CharSequence)"/", (CharSequence)"/", null, (int)0, null, null, (int)60, null));
                UrlKt.parameters((UrlBuilder)$this$url, (Function1)serialize.1.INSTANCE);
            }
        }));
        HttpRequestBuilderKt.headers((HttpRequestBuilder)builder, (Function1)((Function1)new Function1<HeadersBuilder, Unit>(input){
            final /* synthetic */ CreateMultipartUploadRequest $input;
            {
                this.$input = $input;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull HeadersBuilder $this$headers) {
                String string;
                Intrinsics.checkNotNullParameter((Object)$this$headers, (String)"$this$headers");
                if (this.$input.getAcl() != null) {
                    $this$headers.append("x-amz-acl", this.$input.getAcl().getValue());
                }
                if (this.$input.getBucketKeyEnabled()) {
                    $this$headers.append("x-amz-server-side-encryption-bucket-key-enabled", String.valueOf(this.$input.getBucketKeyEnabled()));
                }
                if ((string = this.$input.getCacheControl()) == null ? false : ((CharSequence)string).length() > 0) {
                    $this$headers.append("Cache-Control", this.$input.getCacheControl());
                }
                if (this.$input.getChecksumAlgorithm() != null) {
                    $this$headers.append("x-amz-checksum-algorithm", this.$input.getChecksumAlgorithm().getValue());
                }
                if ((string = this.$input.getContentDisposition()) == null ? false : ((CharSequence)string).length() > 0) {
                    $this$headers.append("Content-Disposition", this.$input.getContentDisposition());
                }
                if ((string = this.$input.getContentEncoding()) == null ? false : ((CharSequence)string).length() > 0) {
                    $this$headers.append("Content-Encoding", this.$input.getContentEncoding());
                }
                if ((string = this.$input.getContentLanguage()) == null ? false : ((CharSequence)string).length() > 0) {
                    $this$headers.append("Content-Language", this.$input.getContentLanguage());
                }
                if ((string = this.$input.getContentType()) == null ? false : ((CharSequence)string).length() > 0) {
                    $this$headers.append("Content-Type", this.$input.getContentType());
                }
                if ((string = this.$input.getExpectedBucketOwner()) == null ? false : ((CharSequence)string).length() > 0) {
                    $this$headers.append("x-amz-expected-bucket-owner", this.$input.getExpectedBucketOwner());
                }
                if (this.$input.getExpires() != null) {
                    $this$headers.append("Expires", this.$input.getExpires().format(TimestampFormat.RFC_5322));
                }
                if ((string = this.$input.getGrantFullControl()) == null ? false : ((CharSequence)string).length() > 0) {
                    $this$headers.append("x-amz-grant-full-control", this.$input.getGrantFullControl());
                }
                if ((string = this.$input.getGrantRead()) == null ? false : ((CharSequence)string).length() > 0) {
                    $this$headers.append("x-amz-grant-read", this.$input.getGrantRead());
                }
                if ((string = this.$input.getGrantReadAcp()) == null ? false : ((CharSequence)string).length() > 0) {
                    $this$headers.append("x-amz-grant-read-acp", this.$input.getGrantReadAcp());
                }
                if ((string = this.$input.getGrantWriteAcp()) == null ? false : ((CharSequence)string).length() > 0) {
                    $this$headers.append("x-amz-grant-write-acp", this.$input.getGrantWriteAcp());
                }
                if (this.$input.getObjectLockLegalHoldStatus() != null) {
                    $this$headers.append("x-amz-object-lock-legal-hold", this.$input.getObjectLockLegalHoldStatus().getValue());
                }
                if (this.$input.getObjectLockMode() != null) {
                    $this$headers.append("x-amz-object-lock-mode", this.$input.getObjectLockMode().getValue());
                }
                if (this.$input.getObjectLockRetainUntilDate() != null) {
                    $this$headers.append("x-amz-object-lock-retain-until-date", this.$input.getObjectLockRetainUntilDate().format(TimestampFormat.ISO_8601));
                }
                if (this.$input.getRequestPayer() != null) {
                    $this$headers.append("x-amz-request-payer", this.$input.getRequestPayer().getValue());
                }
                if ((string = this.$input.getSseCustomerAlgorithm()) == null ? false : ((CharSequence)string).length() > 0) {
                    $this$headers.append("x-amz-server-side-encryption-customer-algorithm", this.$input.getSseCustomerAlgorithm());
                }
                if ((string = this.$input.getSseCustomerKey()) == null ? false : ((CharSequence)string).length() > 0) {
                    $this$headers.append("x-amz-server-side-encryption-customer-key", this.$input.getSseCustomerKey());
                }
                if ((string = this.$input.getSseCustomerKeyMd5()) == null ? false : ((CharSequence)string).length() > 0) {
                    $this$headers.append("x-amz-server-side-encryption-customer-key-MD5", this.$input.getSseCustomerKeyMd5());
                }
                if ((string = this.$input.getSsekmsEncryptionContext()) == null ? false : ((CharSequence)string).length() > 0) {
                    $this$headers.append("x-amz-server-side-encryption-context", this.$input.getSsekmsEncryptionContext());
                }
                if ((string = this.$input.getSsekmsKeyId()) == null ? false : ((CharSequence)string).length() > 0) {
                    $this$headers.append("x-amz-server-side-encryption-aws-kms-key-id", this.$input.getSsekmsKeyId());
                }
                if (this.$input.getServerSideEncryption() != null) {
                    $this$headers.append("x-amz-server-side-encryption", this.$input.getServerSideEncryption().getValue());
                }
                if (this.$input.getStorageClass() != null) {
                    $this$headers.append("x-amz-storage-class", this.$input.getStorageClass().getValue());
                }
                if ((string = this.$input.getTagging()) == null ? false : ((CharSequence)string).length() > 0) {
                    $this$headers.append("x-amz-tagging", this.$input.getTagging());
                }
                if ((string = this.$input.getWebsiteRedirectLocation()) == null ? false : ((CharSequence)string).length() > 0) {
                    $this$headers.append("x-amz-website-redirect-location", this.$input.getWebsiteRedirectLocation());
                }
                Map<String, String> map = this.$input.getMetadata();
                if (map != null) {
                    Map map2;
                    void $this$filterTo$iv$iv;
                    Map<String, String> $this$filter$iv = map;
                    boolean $i$f$filter = false;
                    Object object = $this$filter$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$filterTo = false;
                    Iterator<Map.Entry<K, V>> iterator = $this$filterTo$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> element$iv$iv;
                        Map.Entry<K, V> it = element$iv$iv = iterator.next();
                        boolean bl = false;
                        if (!(it.getValue() != null)) continue;
                        destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                    }
                    Map $this$forEach$iv = map2 = destination$iv$iv;
                    boolean $i$f$forEach = false;
                    object = $this$forEach$iv.entrySet().iterator();
                    while (object.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry $dstr$key$value = element$iv = (Map.Entry)object.next();
                        boolean bl = false;
                        String key = (String)$dstr$key$value.getKey();
                        String value = (String)$dstr$key$value.getValue();
                        String string2 = Intrinsics.stringPlus((String)"x-amz-meta-", (Object)key);
                        String string3 = value;
                        Intrinsics.checkNotNull((Object)string3);
                        $this$headers.append(string2, string3);
                    }
                }
            }
        }));
        return builder;
    }
}

