// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.internal

import aws.sdk.kotlin.runtime.ClientException
import aws.sdk.kotlin.runtime.endpoint.AwsEndpoint
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.endpoint.CredentialScope
import aws.sdk.kotlin.runtime.endpoint.internal.EndpointDefinition
import aws.sdk.kotlin.runtime.endpoint.internal.Partition
import aws.sdk.kotlin.runtime.endpoint.internal.resolveEndpoint

internal class DefaultEndpointResolver : AwsEndpointResolver {
    override suspend fun resolve(service: String, region: String): AwsEndpoint {
        return resolveEndpoint(servicePartitions, region) ?: throw ClientException("unable to resolve endpoint for region: $region")
    }
}

private val servicePartitions = listOf(
    Partition(
        id = "aws",
        regionRegex = Regex("^(us|eu|ap|sa|ca|me|af)\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "s3.{region}.amazonaws.com",
            protocols = listOf("http", "https", ),
            signatureVersions = listOf("s3v4", ),
        ),
        endpoints = mapOf(
            "accesspoint-af-south-1" to EndpointDefinition(
                hostname = "s3-accesspoint.af-south-1.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "accesspoint-ap-east-1" to EndpointDefinition(
                hostname = "s3-accesspoint.ap-east-1.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "accesspoint-ap-northeast-1" to EndpointDefinition(
                hostname = "s3-accesspoint.ap-northeast-1.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "accesspoint-ap-northeast-2" to EndpointDefinition(
                hostname = "s3-accesspoint.ap-northeast-2.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "accesspoint-ap-northeast-3" to EndpointDefinition(
                hostname = "s3-accesspoint.ap-northeast-3.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "accesspoint-ap-south-1" to EndpointDefinition(
                hostname = "s3-accesspoint.ap-south-1.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "accesspoint-ap-southeast-1" to EndpointDefinition(
                hostname = "s3-accesspoint.ap-southeast-1.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "accesspoint-ap-southeast-2" to EndpointDefinition(
                hostname = "s3-accesspoint.ap-southeast-2.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "accesspoint-ca-central-1" to EndpointDefinition(
                hostname = "s3-accesspoint.ca-central-1.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "accesspoint-eu-central-1" to EndpointDefinition(
                hostname = "s3-accesspoint.eu-central-1.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "accesspoint-eu-north-1" to EndpointDefinition(
                hostname = "s3-accesspoint.eu-north-1.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "accesspoint-eu-south-1" to EndpointDefinition(
                hostname = "s3-accesspoint.eu-south-1.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "accesspoint-eu-west-1" to EndpointDefinition(
                hostname = "s3-accesspoint.eu-west-1.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "accesspoint-eu-west-2" to EndpointDefinition(
                hostname = "s3-accesspoint.eu-west-2.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "accesspoint-eu-west-3" to EndpointDefinition(
                hostname = "s3-accesspoint.eu-west-3.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "accesspoint-me-south-1" to EndpointDefinition(
                hostname = "s3-accesspoint.me-south-1.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "accesspoint-sa-east-1" to EndpointDefinition(
                hostname = "s3-accesspoint.sa-east-1.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "accesspoint-us-east-1" to EndpointDefinition(
                hostname = "s3-accesspoint.us-east-1.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "accesspoint-us-east-2" to EndpointDefinition(
                hostname = "s3-accesspoint.us-east-2.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "accesspoint-us-west-1" to EndpointDefinition(
                hostname = "s3-accesspoint.us-west-1.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "accesspoint-us-west-2" to EndpointDefinition(
                hostname = "s3-accesspoint.us-west-2.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "af-south-1" to EndpointDefinition(),
            "ap-east-1" to EndpointDefinition(),
            "ap-northeast-1" to EndpointDefinition(
                hostname = "s3.ap-northeast-1.amazonaws.com",
                signatureVersions = listOf("s3", "s3v4", ),
            ),
            "ap-northeast-2" to EndpointDefinition(),
            "ap-northeast-3" to EndpointDefinition(),
            "ap-south-1" to EndpointDefinition(),
            "ap-southeast-1" to EndpointDefinition(
                hostname = "s3.ap-southeast-1.amazonaws.com",
                signatureVersions = listOf("s3", "s3v4", ),
            ),
            "ap-southeast-2" to EndpointDefinition(
                hostname = "s3.ap-southeast-2.amazonaws.com",
                signatureVersions = listOf("s3", "s3v4", ),
            ),
            "aws-global" to EndpointDefinition(
                hostname = "s3.amazonaws.com",
                credentialScope = CredentialScope(region = "us-east-1",),
                signatureVersions = listOf("s3", "s3v4", ),
            ),
            "ca-central-1" to EndpointDefinition(),
            "eu-central-1" to EndpointDefinition(),
            "eu-north-1" to EndpointDefinition(),
            "eu-south-1" to EndpointDefinition(),
            "eu-west-1" to EndpointDefinition(
                hostname = "s3.eu-west-1.amazonaws.com",
                signatureVersions = listOf("s3", "s3v4", ),
            ),
            "eu-west-2" to EndpointDefinition(),
            "eu-west-3" to EndpointDefinition(),
            "fips-accesspoint-ca-central-1" to EndpointDefinition(
                hostname = "s3-accesspoint-fips.ca-central-1.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "fips-accesspoint-us-east-1" to EndpointDefinition(
                hostname = "s3-accesspoint-fips.us-east-1.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "fips-accesspoint-us-east-2" to EndpointDefinition(
                hostname = "s3-accesspoint-fips.us-east-2.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "fips-accesspoint-us-west-1" to EndpointDefinition(
                hostname = "s3-accesspoint-fips.us-west-1.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "fips-accesspoint-us-west-2" to EndpointDefinition(
                hostname = "s3-accesspoint-fips.us-west-2.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "me-south-1" to EndpointDefinition(),
            "s3-external-1" to EndpointDefinition(
                hostname = "s3-external-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-east-1",),
                signatureVersions = listOf("s3", "s3v4", ),
            ),
            "sa-east-1" to EndpointDefinition(
                hostname = "s3.sa-east-1.amazonaws.com",
                signatureVersions = listOf("s3", "s3v4", ),
            ),
            "us-east-1" to EndpointDefinition(
                hostname = "s3.us-east-1.amazonaws.com",
                signatureVersions = listOf("s3", "s3v4", ),
            ),
            "us-east-2" to EndpointDefinition(),
            "us-west-1" to EndpointDefinition(
                hostname = "s3.us-west-1.amazonaws.com",
                signatureVersions = listOf("s3", "s3v4", ),
            ),
            "us-west-2" to EndpointDefinition(
                hostname = "s3.us-west-2.amazonaws.com",
                signatureVersions = listOf("s3", "s3v4", ),
            ),
        )
    ),
    Partition(
        id = "aws-cn",
        regionRegex = Regex("^cn\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "s3.{region}.amazonaws.com.cn",
            protocols = listOf("http", "https", ),
            signatureVersions = listOf("s3v4", ),
        ),
        endpoints = mapOf(
            "accesspoint-cn-north-1" to EndpointDefinition(
                hostname = "s3-accesspoint.cn-north-1.amazonaws.com.cn",
                signatureVersions = listOf("s3v4", ),
            ),
            "accesspoint-cn-northwest-1" to EndpointDefinition(
                hostname = "s3-accesspoint.cn-northwest-1.amazonaws.com.cn",
                signatureVersions = listOf("s3v4", ),
            ),
            "cn-north-1" to EndpointDefinition(),
            "cn-northwest-1" to EndpointDefinition(),
        )
    ),
    Partition(
        id = "aws-iso",
        regionRegex = Regex("^us\\-iso\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "s3.{region}.c2s.ic.gov",
            protocols = listOf("https", ),
            signatureVersions = listOf("s3v4", ),
        ),
        endpoints = mapOf(
            "us-iso-east-1" to EndpointDefinition(
                protocols = listOf("http", "https", ),
                signatureVersions = listOf("s3v4", ),
            ),
        )
    ),
    Partition(
        id = "aws-iso-b",
        regionRegex = Regex("^us\\-isob\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "s3.{region}.sc2s.sgov.gov",
            protocols = listOf("http", "https", ),
            signatureVersions = listOf("s3v4", ),
        ),
        endpoints = mapOf(
            "us-isob-east-1" to EndpointDefinition(),
        )
    ),
    Partition(
        id = "aws-us-gov",
        regionRegex = Regex("^us\\-gov\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "s3.{region}.amazonaws.com",
            protocols = listOf("https", ),
            signatureVersions = listOf("s3", "s3v4", ),
        ),
        endpoints = mapOf(
            "accesspoint-us-gov-east-1" to EndpointDefinition(
                hostname = "s3-accesspoint.us-gov-east-1.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "accesspoint-us-gov-west-1" to EndpointDefinition(
                hostname = "s3-accesspoint.us-gov-west-1.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "fips-accesspoint-us-gov-east-1" to EndpointDefinition(
                hostname = "s3-accesspoint-fips.us-gov-east-1.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "fips-accesspoint-us-gov-west-1" to EndpointDefinition(
                hostname = "s3-accesspoint-fips.us-gov-west-1.amazonaws.com",
                signatureVersions = listOf("s3v4", ),
            ),
            "fips-us-gov-west-1" to EndpointDefinition(
                hostname = "s3-fips.us-gov-west-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-gov-west-1",),
            ),
            "us-gov-east-1" to EndpointDefinition(
                hostname = "s3.us-gov-east-1.amazonaws.com",
                protocols = listOf("http", "https", ),
            ),
            "us-gov-west-1" to EndpointDefinition(
                hostname = "s3.us-gov-west-1.amazonaws.com",
                protocols = listOf("http", "https", ),
            ),
        )
    ),
)
