// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * Information about the deleted object.
 */
public class DeletedObject private constructor(builder: Builder) {
    /**
     * Specifies whether the versioned object that was permanently deleted was (true) or was not (false) a delete marker. In a simple DELETE, this header indicates whether (true) or not (false) a delete marker was created.
     */
    public val deleteMarker: kotlin.Boolean = builder.deleteMarker
    /**
     * The version ID of the delete marker created as a result of the DELETE operation. If you delete a specific object version, the value returned by this header is the version ID of the object version deleted.
     */
    public val deleteMarkerVersionId: kotlin.String? = builder.deleteMarkerVersionId
    /**
     * The name of the deleted object.
     */
    public val key: kotlin.String? = builder.key
    /**
     * The version ID of the deleted object.
     */
    public val versionId: kotlin.String? = builder.versionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.DeletedObject = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeletedObject(")
        append("deleteMarker=$deleteMarker,")
        append("deleteMarkerVersionId=$deleteMarkerVersionId,")
        append("key=$key,")
        append("versionId=$versionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deleteMarker.hashCode()
        result = 31 * result + (deleteMarkerVersionId?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeletedObject

        if (deleteMarker != other.deleteMarker) return false
        if (deleteMarkerVersionId != other.deleteMarkerVersionId) return false
        if (key != other.key) return false
        if (versionId != other.versionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.DeletedObject = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether the versioned object that was permanently deleted was (true) or was not (false) a delete marker. In a simple DELETE, this header indicates whether (true) or not (false) a delete marker was created.
         */
        public var deleteMarker: kotlin.Boolean = false
        /**
         * The version ID of the delete marker created as a result of the DELETE operation. If you delete a specific object version, the value returned by this header is the version ID of the object version deleted.
         */
        public var deleteMarkerVersionId: kotlin.String? = null
        /**
         * The name of the deleted object.
         */
        public var key: kotlin.String? = null
        /**
         * The version ID of the deleted object.
         */
        public var versionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.DeletedObject) : this() {
            this.deleteMarker = x.deleteMarker
            this.deleteMarkerVersionId = x.deleteMarkerVersionId
            this.key = x.key
            this.versionId = x.versionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.DeletedObject = DeletedObject(this)
    }
}
